package adapter;

/**
 * Copyright (c) 2021, ustchcs and its affiliates. All rights reserved. More info see www.ustchcs.com
 *
 * @author cch
 * @package Thymeleaf1 com.example.demo.design.adapter
 * @node
 */
public class AdapterDesign {
    public static void main(String[] args) {
        AliLogger aliLogger = new AliLogger();
        CloudLoggerAdapter adapter = new CloudLoggerAdapter(aliLogger);
        NoticeService noticeService = new NoticeService(adapter);
        noticeService.send("aaaa");
    }
}

interface Logger {
    public void info(String message);
}

interface CloudLogger {
    public void sendToServer(String code, String message);
}

class AliLogger implements CloudLogger {

    @Override
    public void sendToServer(String code, String message) {
        System.out.println(code + "-" + message);
    }
}

class CloudLoggerAdapter implements Logger {
    private CloudLogger cloudLogger;

    public CloudLoggerAdapter(CloudLogger cloudLogger) {
        this.cloudLogger = cloudLogger;
    }

    @Override
    public void info(String message) {
        this.cloudLogger.sendToServer("info", message);
    }
}

class NoticeService {
    protected Logger logger;

    public NoticeService(Logger logger) {
        this.logger = logger;
    }

    public void send(String message) {
        this.logger.info(message);
    }
}
