package strategy;

/**
 * Copyright (c) 2023, ustchcs and its affiliates. All rights reserved. More info see www.ustchcs.com
 *
 * @author cch
 * @package java-test strategy
 * @node
 */
public class CustomAuthenticator {
    private IStrategy strategy;

    public CustomAuthenticator(IStrategy strategyInput) {
        this.strategy = strategyInput;
    }

    public void authenticate(String name, String password) {
        if (this.strategy == null) {
            System.out.println("no strategy");
            return;
        }
        this.strategy.authenticate(name, password);
    }

    public void setStrategy(IStrategy strategy) {
        this.strategy = strategy;
    }
}
