/*
 * Decompiled with CFR 0.152.
 */
package cn.throwx.canal.gule.util;

import cn.throwx.canal.gule.util.AssertUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public enum ReflectionUtils {
    X;

    private static final Field[] EMPTY_FIELD_ARRAY;
    private static final Map<Class<?>, Field[]> DECLARED_FIELDS_CACHE;

    private Field[] getDeclaredFields(Class<?> clazz) {
        AssertUtils.X.notNull(clazz, "Class must not be null");
        Field[] result = DECLARED_FIELDS_CACHE.get(clazz);
        if (Objects.isNull(result)) {
            try {
                result = clazz.getDeclaredFields();
                DECLARED_FIELDS_CACHE.put(clazz, result.length == 0 ? EMPTY_FIELD_ARRAY : result);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", e);
            }
        }
        return result;
    }

    public void doWithFields(Class<?> clazz, FieldCallback fieldCallback) {
        this.doWithFields(clazz, fieldCallback, null);
    }

    public void doWithFields(Class<?> clazz, FieldCallback fieldCallback, FieldFilter fieldFilter) {
        Class<?> targetClass = clazz;
        do {
            for (Field field : this.getDeclaredFields(targetClass)) {
                if (null != fieldFilter && !fieldFilter.matches(field)) continue;
                try {
                    fieldCallback.doWith(field);
                }
                catch (IllegalAccessException var10) {
                    throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + var10);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    static {
        EMPTY_FIELD_ARRAY = new Field[0];
        DECLARED_FIELDS_CACHE = new ConcurrentHashMap(32);
    }

    @FunctionalInterface
    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    @FunctionalInterface
    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

