/*
 * Decompiled with CFR 0.152.
 */
package cn.throwx.canal.gule.support.parser;

import cn.throwx.canal.gule.common.BinLogEventType;
import cn.throwx.canal.gule.common.OperationType;
import cn.throwx.canal.gule.model.CanalBinLogEvent;
import cn.throwx.canal.gule.model.CanalBinLogResult;
import cn.throwx.canal.gule.support.parser.BaseCommonEntryFunction;
import cn.throwx.canal.gule.support.parser.BasePrimaryKeyTupleFunction;
import cn.throwx.canal.gule.support.parser.CanalBinLogEventParser;
import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCanalBinLogEventParser
implements CanalBinLogEventParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultCanalBinLogEventParser.class);

    @Override
    public <T> List<CanalBinLogResult<T>> parse(CanalBinLogEvent event, Class<T> klass, BasePrimaryKeyTupleFunction primaryKeyFunction, BaseCommonEntryFunction<T> commonEntryFunction) {
        int oldSize;
        BinLogEventType eventType = BinLogEventType.fromType(event.getType());
        if (BinLogEventType.UNKNOWN == eventType || BinLogEventType.QUERY == eventType) {
            if (log.isDebugEnabled()) {
                log.debug("\u76d1\u542c\u5230\u4e0d\u9700\u8981\u5904\u7406\u6216\u8005\u672a\u77e5\u7684binlog\u4e8b\u4ef6\u7c7b\u578b[{}],\u5c06\u5ffd\u7565\u89e3\u6790\u8fc7\u7a0b\u8fd4\u56de\u7a7a\u5217\u8868,binlog\u4e8b\u4ef6:{}", (Object)eventType, (Object)JSON.toJSONString((Object)event));
            }
            return Collections.emptyList();
        }
        if (Boolean.TRUE.equals(event.getIsDdl())) {
            CanalBinLogResult entry = new CanalBinLogResult();
            entry.setOperationType(OperationType.DDL);
            entry.setBinLogEventType(eventType);
            entry.setDatabaseName(event.getDatabase());
            entry.setTableName(event.getTable());
            entry.setSql(event.getSql());
            return Collections.singletonList(entry);
        }
        Optional.ofNullable(event.getPkNames()).filter(x -> x.size() == 1).orElseThrow(() -> new IllegalArgumentException("DML\u7c7b\u578bbinlog\u4e8b\u4ef6\u4e3b\u952e\u5217\u6570\u91cf\u4e0d\u4e3a1"));
        String primaryKeyName = event.getPkNames().get(0);
        LinkedList<CanalBinLogResult<T>> entryList = new LinkedList<CanalBinLogResult<T>>();
        List<Map<String, String>> data = event.getData();
        List<Map<String, String>> old = event.getOld();
        int dataSize = null != data ? data.size() : 0;
        int n = oldSize = null != old ? old.size() : 0;
        if (dataSize > 0) {
            for (int index = 0; index < dataSize; ++index) {
                CanalBinLogResult<T> entry = new CanalBinLogResult<T>();
                entryList.add(entry);
                entry.setSql(event.getSql());
                entry.setOperationType(OperationType.DML);
                entry.setBinLogEventType(eventType);
                entry.setTableName(event.getTable());
                entry.setDatabaseName(event.getDatabase());
                Map<String, String> item = data.get(index);
                entry.setAfterData(commonEntryFunction.apply(item));
                Map<String, String> oldItem = null;
                if (oldSize > 0 && index <= oldSize) {
                    oldItem = old.get(index);
                    entry.setBeforeData(commonEntryFunction.apply(oldItem));
                }
                entry.setPrimaryKey(primaryKeyFunction.apply(oldItem, item, primaryKeyName));
            }
        }
        return entryList;
    }

    private DefaultCanalBinLogEventParser() {
    }

    public static DefaultCanalBinLogEventParser of() {
        return new DefaultCanalBinLogEventParser();
    }
}

