/*
 * Decompiled with CFR 0.152.
 */
package cn.throwx.canal.gule.support.parser;

import cn.throwx.canal.gule.support.parser.BaseParseResultInterceptor;
import cn.throwx.canal.gule.support.parser.ModelTableMetadata;
import cn.throwx.canal.gule.support.parser.ModelTableMetadataManager;
import cn.throwx.canal.gule.support.parser.ParseResultInterceptorManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InMemoryParseResultInterceptorManager
implements ParseResultInterceptorManager {
    private final ConcurrentMap<Class<?>, List<BaseParseResultInterceptor<?>>> cache = new ConcurrentHashMap(16);
    private final ModelTableMetadataManager modelTableMetadataManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void registerParseResultInterceptor(BaseParseResultInterceptor<T> parseResultInterceptor) {
        ConcurrentMap<Class<?>, List<BaseParseResultInterceptor<?>>> concurrentMap = this.cache;
        synchronized (concurrentMap) {
            Class klass = parseResultInterceptor.getKlass();
            ModelTableMetadata modelTableMetadata = this.modelTableMetadataManager.load(klass);
            Optional.ofNullable(modelTableMetadata).ifPresent(ignore -> {
                this.cache.putIfAbsent(parseResultInterceptor.getKlass(), new LinkedList());
                ((List)this.cache.get(klass)).add(parseResultInterceptor);
            });
        }
    }

    @Override
    public <T> List<BaseParseResultInterceptor<T>> getParseResultInterceptors(Class<T> klass) {
        return this.cache.getOrDefault(klass, Collections.emptyList());
    }

    private InMemoryParseResultInterceptorManager(ModelTableMetadataManager modelTableMetadataManager) {
        this.modelTableMetadataManager = modelTableMetadataManager;
    }

    public static InMemoryParseResultInterceptorManager of(ModelTableMetadataManager modelTableMetadataManager) {
        return new InMemoryParseResultInterceptorManager(modelTableMetadataManager);
    }
}

