/*
 * Decompiled with CFR 0.152.
 */
package cn.throwx.canal.gule.support.parser;

import cn.throwx.canal.gule.annotation.CanalField;
import cn.throwx.canal.gule.annotation.CanalModel;
import cn.throwx.canal.gule.common.FieldNamingPolicy;
import cn.throwx.canal.gule.model.ModelTable;
import cn.throwx.canal.gule.support.parser.ColumnMetadata;
import cn.throwx.canal.gule.support.parser.ModelTableMetadata;
import cn.throwx.canal.gule.support.parser.ModelTableMetadataManager;
import cn.throwx.canal.gule.support.parser.converter.BaseCanalFieldConverter;
import cn.throwx.canal.gule.support.parser.converter.CanalFieldConvertInput;
import cn.throwx.canal.gule.support.parser.converter.CanalFieldConvertResult;
import cn.throwx.canal.gule.support.parser.converter.CanalFieldConverterFactory;
import cn.throwx.canal.gule.util.AssertUtils;
import cn.throwx.canal.gule.util.ReflectionUtils;
import cn.throwx.canal.gule.util.StringUtils;
import java.sql.JDBCType;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InMemoryModelTableMetadataManager
implements ModelTableMetadataManager {
    private final ConcurrentMap<Class<?>, ModelTableMetadata> cache = new ConcurrentHashMap(16);
    private final CanalFieldConverterFactory canalFieldConverterFactory;

    @Override
    public ModelTableMetadata load(Class<?> klass) {
        return this.cache.computeIfAbsent(klass, clazz -> {
            AssertUtils.X.isTrue(klass.isAnnotationPresent(CanalModel.class), String.format("[%s]\u6ca1\u6709\u4f7f\u7528@CanalModel\u6ce8\u89e3", klass.getName()));
            CanalModel canalModel = klass.getAnnotation(CanalModel.class);
            FieldNamingPolicy namingPolicy = canalModel.fieldNamingPolicy();
            ModelTableMetadata metadata = new ModelTableMetadata();
            metadata.setModelTable(ModelTable.of(canalModel.database(), canalModel.table()));
            HashMap<String, ColumnMetadata> fieldColumnMapping = new HashMap<String, ColumnMetadata>(8);
            ReflectionUtils.X.doWithFields(klass, field -> {
                JDBCType sqlType = null;
                Class<? extends BaseCanalFieldConverter<?>> converterKlass = null;
                String columnName = null;
                if (field.isAnnotationPresent(CanalField.class)) {
                    CanalField canalField = field.getAnnotation(CanalField.class);
                    sqlType = canalField.sqlType();
                    converterKlass = canalField.converterKlass();
                    if (StringUtils.X.isNotEmpty(canalField.columnName())) {
                        columnName = canalField.columnName();
                    }
                }
                String fieldName = field.getName();
                if (null == columnName) {
                    columnName = namingPolicy.convert(fieldName);
                }
                CanalFieldConvertInput input = CanalFieldConvertInput.builder().fieldKlass(field.getType()).sqlType(sqlType).converterKlass(converterKlass).build();
                CanalFieldConvertResult result = this.canalFieldConverterFactory.load(input);
                ColumnMetadata columnMetadata = new ColumnMetadata();
                columnMetadata.setColumnName(columnName);
                columnMetadata.setConverter(result.getConverter());
                fieldColumnMapping.put(fieldName, columnMetadata);
            });
            metadata.setFieldColumnMapping(fieldColumnMapping);
            return metadata;
        });
    }

    private InMemoryModelTableMetadataManager(CanalFieldConverterFactory canalFieldConverterFactory) {
        this.canalFieldConverterFactory = canalFieldConverterFactory;
    }

    public static InMemoryModelTableMetadataManager of(CanalFieldConverterFactory canalFieldConverterFactory) {
        return new InMemoryModelTableMetadataManager(canalFieldConverterFactory);
    }
}

