/*
 * Decompiled with CFR 0.152.
 */
package cn.throwx.canal.gule.support;

import cn.throwx.canal.gule.util.AssertUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class BaseParameterizedTypeReferenceSupport<T> {
    private final Class<T> klass;
    private final Class<?> childKlass = this.getClass();

    public BaseParameterizedTypeReferenceSupport() {
        Type type = BaseParameterizedTypeReferenceSupport.findParameterizedTypeReferenceSubClass(this.childKlass);
        AssertUtils.X.isInstanceOf(ParameterizedType.class, type, "Type must be a parameterized type");
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        AssertUtils.X.isTrue(actualTypeArguments.length == 1, "Number of type arguments must be 1");
        this.klass = (Class)actualTypeArguments[0];
    }

    private static Type findParameterizedTypeReferenceSubClass(Class<?> child) {
        Type genericSuperclass = child.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            Class<?> parent = child.getSuperclass();
            if (Object.class == parent) {
                throw new IllegalStateException("Expected ParameterizedTypeReference superclass");
            }
            return BaseParameterizedTypeReferenceSupport.findParameterizedTypeReferenceSubClass(parent);
        }
        return genericSuperclass;
    }

    public Class<T> getKlass() {
        return this.klass;
    }

    public Class<?> getChildKlass() {
        return this.childKlass;
    }
}

