/*
 * Decompiled with CFR 0.152.
 */
package cn.throwx.canal.gule.support.processor;

import cn.throwx.canal.gule.common.BinLogEventType;
import cn.throwx.canal.gule.common.OperationType;
import cn.throwx.canal.gule.model.CanalBinLogEvent;
import cn.throwx.canal.gule.model.CanalBinLogResult;
import cn.throwx.canal.gule.model.ModelTable;
import cn.throwx.canal.gule.support.BaseParameterizedTypeReferenceSupport;
import cn.throwx.canal.gule.support.parser.BaseCommonEntryFunction;
import cn.throwx.canal.gule.support.parser.BaseParseResultInterceptor;
import cn.throwx.canal.gule.support.parser.BasePrimaryKeyTupleFunction;
import cn.throwx.canal.gule.support.parser.BigIntPrimaryKeyTupleFunction;
import cn.throwx.canal.gule.support.parser.CanalBinLogEventParser;
import cn.throwx.canal.gule.support.parser.ModelTableMetadata;
import cn.throwx.canal.gule.support.parser.ModelTableMetadataManager;
import cn.throwx.canal.gule.support.parser.ParseResultInterceptorManager;
import cn.throwx.canal.gule.support.parser.ReflectionBinLogEntryFunction;
import cn.throwx.canal.gule.support.processor.CanalBinlogEventProcessorFactory;
import cn.throwx.canal.gule.support.processor.ExceptionHandler;
import cn.throwx.canal.gule.util.AssertUtils;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCanalBinlogEventProcessor<T>
extends BaseParameterizedTypeReferenceSupport<T> {
    private BasePrimaryKeyTupleFunction primaryKeyFunction;
    private BaseCommonEntryFunction<T> commonEntryFunction;
    private ExceptionHandler exceptionHandler;
    private List<BaseParseResultInterceptor<T>> parseResultInterceptors;
    private CanalBinLogEventParser canalBinLogEventParser;
    protected final Logger logger = LoggerFactory.getLogger(this.getChildKlass());
    private final AtomicBoolean init = new AtomicBoolean(false);

    protected BaseCanalBinlogEventProcessor() {
    }

    public final void init(CanalBinLogEventParser canalBinLogEventParser, ModelTableMetadataManager modelTableMetadataManager, CanalBinlogEventProcessorFactory canalBinlogEventProcessorFactory, ParseResultInterceptorManager parseResultInterceptorManager) {
        AssertUtils.X.notNull(canalBinLogEventParser, "CanalBinLogEventParser");
        AssertUtils.X.notNull(modelTableMetadataManager, "ModelTableMetadataManager");
        AssertUtils.X.notNull(canalBinlogEventProcessorFactory, "CanalBinlogEventProcessorFactory");
        AssertUtils.X.notNull(parseResultInterceptorManager, "ParseResultInterceptorManager");
        if (this.init.compareAndSet(false, true)) {
            this.canalBinLogEventParser = canalBinLogEventParser;
            Class modelKlass = this.getKlass();
            ModelTableMetadata modelTableMetadata = modelTableMetadataManager.load(modelKlass);
            ModelTable modelTable = modelTableMetadata.getModelTable();
            this.primaryKeyFunction = Optional.ofNullable(this.primaryKeyFunction()).orElse(BigIntPrimaryKeyTupleFunction.X);
            this.commonEntryFunction = Optional.ofNullable(this.commonEntryFunction()).orElse(ReflectionBinLogEntryFunction.of(modelKlass, modelTableMetadata));
            this.exceptionHandler = Optional.ofNullable(this.exceptionHandler()).orElse(ExceptionHandler.NO_OP);
            this.parseResultInterceptors = Optional.ofNullable(this.parseResultInterceptors()).orElse(parseResultInterceptorManager.getParseResultInterceptors(modelKlass));
            canalBinlogEventProcessorFactory.register(modelTable, this);
            this.logger.info("\u521d\u59cb\u5316binlog\u5904\u7406\u5668\u6210\u529f,\u6570\u636e\u5e93:{},\u8868:{} -> {}", new Object[]{modelTable.database(), modelTable.table(), this.getChildKlass().getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(CanalBinLogEvent event) {
        AssertUtils.X.isTrue(this.init.get(), String.format("Processor %s Not Init!", this.getChildKlass().getSimpleName()));
        ModelTable modelTable = ModelTable.of(event.getDatabase(), event.getTable());
        try {
            this.onParse(modelTable);
            List resultList = this.canalBinLogEventParser.parse(event, this.getKlass(), this.primaryKeyFunction, this.commonEntryFunction);
            Optional.ofNullable(resultList).ifPresent(list -> list.forEach(result -> {
                if (BinLogEventType.INSERT == result.getBinLogEventType() && OperationType.DML == result.getOperationType()) {
                    this.onBeforeInsertProcess(modelTable, result.getBeforeData(), result.getAfterData());
                    this.processInsertInternal((CanalBinLogResult<T>)result);
                    this.onAfterInsertProcess(modelTable, result.getBeforeData(), result.getAfterData());
                }
                if (BinLogEventType.UPDATE == result.getBinLogEventType() && OperationType.DML == result.getOperationType()) {
                    this.onBeforeUpdateProcess(modelTable, result.getBeforeData(), result.getAfterData());
                    this.processUpdateInternal((CanalBinLogResult<T>)result);
                    this.onAfterUpdateProcess(modelTable, result.getBeforeData(), result.getAfterData());
                }
                if (BinLogEventType.DELETE == result.getBinLogEventType() && OperationType.DML == result.getOperationType()) {
                    this.onBeforeDeleteProcess(modelTable, result.getBeforeData(), result.getAfterData());
                    this.processDeleteInternal((CanalBinLogResult<T>)result);
                    this.onAfterDeleteProcess(modelTable, result.getBeforeData(), result.getAfterData());
                }
                if (OperationType.DDL == result.getOperationType()) {
                    this.onBeforeDDLProcess(modelTable, result.getBeforeData(), result.getAfterData(), result.getSql());
                    this.processDDLInternal((CanalBinLogResult<T>)result);
                    this.onAfterDDLProcess(modelTable, result.getBeforeData(), result.getAfterData(), result.getSql());
                }
            }));
            this.onParseFinish(modelTable);
        }
        catch (Exception e) {
            this.exceptionHandler.onError(event, e);
        }
        finally {
            this.onParseCompletion(modelTable);
        }
    }

    private void onParse(ModelTable modelTable) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onParse(modelTable)));
    }

    private void onParseFinish(ModelTable modelTable) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onParseFinish(modelTable)));
    }

    private void onBeforeInsertProcess(ModelTable modelTable, T before, T after) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onBeforeInsertProcess(modelTable, before, after)));
    }

    private void onAfterInsertProcess(ModelTable modelTable, T before, T after) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onAfterInsertProcess(modelTable, before, after)));
    }

    private void onBeforeUpdateProcess(ModelTable modelTable, T before, T after) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onBeforeUpdateProcess(modelTable, before, after)));
    }

    private void onAfterUpdateProcess(ModelTable modelTable, T before, T after) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onAfterUpdateProcess(modelTable, before, after)));
    }

    private void onBeforeDeleteProcess(ModelTable modelTable, T before, T after) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onBeforeDeleteProcess(modelTable, before, after)));
    }

    private void onAfterDeleteProcess(ModelTable modelTable, T before, T after) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onAfterDeleteProcess(modelTable, before, after)));
    }

    private void onBeforeDDLProcess(ModelTable modelTable, T before, T after, String sql) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onBeforeDDLProcess(modelTable, before, after, sql)));
    }

    private void onAfterDDLProcess(ModelTable modelTable, T before, T after, String sql) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onAfterDDLProcess(modelTable, before, after, sql)));
    }

    private void onParseCompletion(ModelTable modelTable) {
        Optional.ofNullable(this.parseResultInterceptors).ifPresent(items -> items.forEach(item -> item.onParseCompletion(modelTable)));
    }

    protected BasePrimaryKeyTupleFunction primaryKeyFunction() {
        return null;
    }

    protected BaseCommonEntryFunction<T> commonEntryFunction() {
        return null;
    }

    protected ExceptionHandler exceptionHandler() {
        return null;
    }

    protected List<BaseParseResultInterceptor<T>> parseResultInterceptors() {
        return null;
    }

    protected void processInsertInternal(CanalBinLogResult<T> result) {
    }

    protected void processUpdateInternal(CanalBinLogResult<T> result) {
    }

    protected void processDeleteInternal(CanalBinLogResult<T> result) {
    }

    protected void processDDLInternal(CanalBinLogResult<T> result) {
    }
}

