# 目录结构

```
mall4cloud
├── mall4cloud-api -- api接口，仅对内使用，一般用来放feign的接口，对内使用
├   └── mall4cloud-api-auth -- 授权 feign接口（只要需要授权验证的微服务，就需要用到该接口）
├   └── mall4cloud-api-leaf -- 分布式id feign接口（需要生成分布式唯一id的，就需要用到该接口）
├   └── mall4cloud-api-rbac -- 用户角色权限 feign接口（如果一个服务，需要校验菜单权限，就需要用到该接口）
├── mall4cloud-auth -- 授权服务，用户登陆生成token并返回，token的校验等就是使用该服务的
├── mall4cloud-biz -- 第三方业务服务，如minio文件上传等
├── mall4cloud-common -- 一些公共业务
├   └── mall4cloud-common-cache -- 缓存模块
├   └── mall4cloud-common-core -- 一些常用核心代码模块
├   └── mall4cloud-common-database -- 数据库模块
├   └── mall4cloud-common-database -- 验证授权等安全模块
├── mall4cloud-gateway -- 网关服务
├── mall4cloud-leaf -- 分布式id服务（使用美团的leaf创建分布式id）
├── mall4cloud-multishop -- 商家服务
├── mall4cloud-order -- 订单服务
├── mall4cloud-payment -- 支付服务
├── mall4cloud-platform -- 平台服务
├── mall4cloud-product -- 商品服务
├── mall4cloud-rbac -- 菜单服务
├── mall4cloud-search -- 搜索服务（使用elasticsearch实现）
├── mall4cloud-user -- 用户服务
```
