/*
 * Decompiled with CFR 0.152.
 */
package cn.throwx.canal.gule.support.processor;

import cn.throwx.canal.gule.model.ModelTable;
import cn.throwx.canal.gule.support.processor.BaseCanalBinlogEventProcessor;
import cn.throwx.canal.gule.support.processor.CanalBinlogEventProcessorFactory;
import cn.throwx.canal.gule.util.AssertUtils;
import cn.throwx.canal.gule.util.CollectionUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InMemoryCanalBinlogEventProcessorFactory
implements CanalBinlogEventProcessorFactory {
    private final ConcurrentMap<ModelTable, List<BaseCanalBinlogEventProcessor<?>>> cache = new ConcurrentHashMap(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ModelTable modelTable, BaseCanalBinlogEventProcessor<?> processor) {
        ConcurrentMap<ModelTable, List<BaseCanalBinlogEventProcessor<?>>> concurrentMap = this.cache;
        synchronized (concurrentMap) {
            this.cache.putIfAbsent(modelTable, new LinkedList());
            ((List)this.cache.get(modelTable)).add(processor);
        }
    }

    @Override
    public List<BaseCanalBinlogEventProcessor<?>> get(ModelTable modelTable) {
        List processors = (List)this.cache.get(modelTable);
        AssertUtils.X.isTrue(CollectionUtils.X.isNotEmpty(processors), String.format("Processor Not Found For %s", modelTable));
        return processors;
    }

    private InMemoryCanalBinlogEventProcessorFactory() {
    }

    public static InMemoryCanalBinlogEventProcessorFactory of() {
        return new InMemoryCanalBinlogEventProcessorFactory();
    }
}

