/*
 * Decompiled with CFR 0.152.
 */
package cn.throwx.canal.gule.support.parser;

import cn.throwx.canal.gule.support.parser.BaseCommonEntryFunction;
import cn.throwx.canal.gule.support.parser.ColumnMetadata;
import cn.throwx.canal.gule.support.parser.ModelTableMetadata;
import cn.throwx.canal.gule.util.AssertUtils;
import cn.throwx.canal.gule.util.ClassUtils;
import cn.throwx.canal.gule.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionBinLogEntryFunction<T>
extends BaseCommonEntryFunction<T> {
    private static final Logger log = LoggerFactory.getLogger(ReflectionBinLogEntryFunction.class);
    private final Class<T> klass;
    private final ModelTableMetadata modelTableMetadata;

    @Override
    public T apply(Map<String, String> data) {
        Constructor<T> constructor = ClassUtils.X.getConstructorIfAvailable(this.klass, new Class[0]);
        if (Objects.nonNull(constructor)) {
            try {
                T instance = constructor.newInstance(new Object[0]);
                Map<String, ColumnMetadata> fieldColumnMapping = this.modelTableMetadata.getFieldColumnMapping();
                ReflectionUtils.X.doWithFields(this.klass, field -> {
                    String fieldName = field.getName();
                    ColumnMetadata columnMetadata = (ColumnMetadata)fieldColumnMapping.get(fieldName);
                    AssertUtils.X.notNull(columnMetadata, String.format("[%s.%s]\u5c5e\u6027\u83b7\u53d6\u5217\u5c5e\u6027\u5143\u6570\u636e\u5931\u8d25", this.klass.getSimpleName(), fieldName));
                    String value = (String)data.get(columnMetadata.getColumnName());
                    if (null != value) {
                        Object convertValue = columnMetadata.getConverter().convert(value);
                        ReflectionUtils.X.makeAccessible(field);
                        field.set(instance, convertValue);
                    }
                });
                return instance;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException(String.format("\u57fa\u4e8e\u7c7b\u578b[%s]\u5b9e\u4f8b\u5316\u548c\u53cd\u5c04\u8d4b\u503c\u5931\u8d25,\u8bf7\u786e\u5b9a\u662f\u5426\u63d0\u4f9b\u4e86\u9ed8\u8ba4\u7684\u6784\u9020\u51fd\u6570", this.klass.getName()));
    }

    public Class<T> getKlass() {
        return this.klass;
    }

    public ModelTableMetadata getModelTableMetadata() {
        return this.modelTableMetadata;
    }

    private ReflectionBinLogEntryFunction(Class<T> klass, ModelTableMetadata modelTableMetadata) {
        this.klass = klass;
        this.modelTableMetadata = modelTableMetadata;
    }

    public static <T> ReflectionBinLogEntryFunction<T> of(Class<T> klass, ModelTableMetadata modelTableMetadata) {
        return new ReflectionBinLogEntryFunction<T>(klass, modelTableMetadata);
    }
}

