/*
 * Decompiled with CFR 0.152.
 */
package cn.throwx.canal.gule.support.parser.converter;

import cn.throwx.canal.gule.support.parser.converter.BaseCanalFieldConverter;
import cn.throwx.canal.gule.support.parser.converter.BigIntCanalFieldConverter;
import cn.throwx.canal.gule.support.parser.converter.CanalFieldConvertInput;
import cn.throwx.canal.gule.support.parser.converter.CanalFieldConvertResult;
import cn.throwx.canal.gule.support.parser.converter.CanalFieldConverterFactory;
import cn.throwx.canal.gule.support.parser.converter.DecimalCanalFieldConverter;
import cn.throwx.canal.gule.support.parser.converter.IntCanalFieldConverter;
import cn.throwx.canal.gule.support.parser.converter.NullCanalFieldConverter;
import cn.throwx.canal.gule.support.parser.converter.SqlDateCanalFieldConverter0;
import cn.throwx.canal.gule.support.parser.converter.SqlDateCanalFieldConverter1;
import cn.throwx.canal.gule.support.parser.converter.TimestampCanalFieldConverter0;
import cn.throwx.canal.gule.support.parser.converter.TimestampCanalFieldConverter1;
import cn.throwx.canal.gule.support.parser.converter.TimestampCanalFieldConverter2;
import cn.throwx.canal.gule.support.parser.converter.TinyIntCanalFieldConverter;
import cn.throwx.canal.gule.support.parser.converter.VarcharCanalFieldConverter;
import com.alibaba.fastjson.JSON;
import java.sql.SQLType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InMemoryCanalFieldConverterFactory
implements CanalFieldConverterFactory {
    private final Set<BaseCanalFieldConverter> converters = new HashSet<BaseCanalFieldConverter>(16);
    private final ConcurrentMap<Class<?>, BaseCanalFieldConverter> typeKlassConverters = new ConcurrentHashMap(16);
    private final ConcurrentMap<SQLType, BaseCanalFieldConverter> sqlTypeConverters = new ConcurrentHashMap<SQLType, BaseCanalFieldConverter>(16);
    private final ConcurrentMap<Class<? extends BaseCanalFieldConverter>, BaseCanalFieldConverter> klassConverters = new ConcurrentHashMap<Class<? extends BaseCanalFieldConverter>, BaseCanalFieldConverter>(16);

    public static CanalFieldConverterFactory of() {
        return new InMemoryCanalFieldConverterFactory();
    }

    private InMemoryCanalFieldConverterFactory() {
        this.loadInternalConverters();
    }

    private void loadInternalConverters() {
        this.converters.add(NullCanalFieldConverter.X);
        this.converters.add(BigIntCanalFieldConverter.X);
        this.converters.add(VarcharCanalFieldConverter.X);
        this.converters.add(IntCanalFieldConverter.X);
        this.converters.add(DecimalCanalFieldConverter.X);
        this.converters.add(TinyIntCanalFieldConverter.X);
        this.converters.add(TimestampCanalFieldConverter0.X);
        this.converters.add(SqlDateCanalFieldConverter0.X);
        this.converters.add(TimestampCanalFieldConverter1.X);
        this.converters.add(SqlDateCanalFieldConverter1.X);
        this.converters.add(TimestampCanalFieldConverter2.X);
        this.converters.forEach(converter -> this.registerConverter((BaseCanalFieldConverter<?>)converter, true));
    }

    @Override
    public void registerConverter(BaseCanalFieldConverter<?> converter, boolean replace) {
        if (replace) {
            this.typeKlassConverters.put(converter.typeKlass(), converter);
            this.sqlTypeConverters.put(converter.sqlType(), converter);
            this.klassConverters.put(converter.getClass(), converter);
        } else {
            this.typeKlassConverters.putIfAbsent(converter.typeKlass(), converter);
            this.sqlTypeConverters.putIfAbsent(converter.sqlType(), converter);
            this.klassConverters.putIfAbsent(converter.getClass(), converter);
        }
    }

    @Override
    public CanalFieldConvertResult load(CanalFieldConvertInput input) {
        BaseCanalFieldConverter converter;
        if (null != input.getSqlType() && null != (converter = (BaseCanalFieldConverter)this.sqlTypeConverters.get(input.getSqlType()))) {
            return CanalFieldConvertResult.builder().converter(converter).build();
        }
        if (null != input.getConverterKlass() && null != (converter = (BaseCanalFieldConverter)this.klassConverters.get(input.getConverterKlass()))) {
            return CanalFieldConvertResult.builder().converter(converter).build();
        }
        if (null != input.getFieldKlass() && null != (converter = (BaseCanalFieldConverter)this.typeKlassConverters.get(input.getFieldKlass()))) {
            return CanalFieldConvertResult.builder().converter(converter).build();
        }
        throw new IllegalArgumentException(String.format("\u52a0\u8f7dCanal\u7c7b\u578b\u8f6c\u6362\u5668\u5931\u8d25,\u8f93\u5165\u53c2\u6570:%s", JSON.toJSONString((Object)input)));
    }
}

