/*
 * Copyright (c) 2020, 2021, ustchcs and/or its affiliates. All rights reserved.
 * More info see www.ustchcs.com
 */


package com.ustchcs.rule.bugfinder.testcase;

import java.util.Objects;
import java.util.concurrent.Flow.Publisher;
import java.util.function.Function;

public class Bugfinder_6_2_EXP {

    public static <T, R> void combineLatest(Iterable<? extends Publisher<? extends T>> sources,
            Function<? super Object[], ? extends R> combiner, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(combiner, "combiner is null");
        System.out.println(new FlowableCombineLatest<>(sources, combiner, bufferSize, false));
    }

}

final class FlowableCombineLatest<T, R> {

    final Publisher<? extends T>[] array;

    final Iterable<? extends Publisher<? extends T>> iterable;

    final Function<? super Object[], ? extends R> combiner;

    final int bufferSize;

    final boolean delayErrors;

    public FlowableCombineLatest(Publisher<? extends T>[] array, Function<? super Object[], ? extends R> combiner,
            int bufferSize, boolean delayErrors) {
        this.array = array;
        this.iterable = null;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    public FlowableCombineLatest(Iterable<? extends Publisher<? extends T>> iterable,
            Function<? super Object[], ? extends R> combiner, int bufferSize, boolean delayErrors) {
        this.array = null;
        this.iterable = iterable;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }
}
