/**
* OWASP Benchmark Project v1.2
*
* This file is part of the Open Web Application Security Project (OWASP)
* Benchmark Project. For details, please see
* <a href="https://www.owasp.org/index.php/Benchmark">https://www.owasp.org/index.php/Benchmark</a>.
*
* The OWASP Benchmark is free software: you can redistribute it and/or modify it under the terms
* of the GNU General Public License as published by the Free Software Foundation, version 2.
*
* The OWASP Benchmark is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* @author Nick Sanidas <a href="https://www.aspectsecurity.com">Aspect Security</a>
* @created 2015
*/

package org.owasp.benchmark.testcode;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value="/pathtraver-02/BenchmarkTest01841")
public class BenchmarkTest01841 extends HttpServlet {
	
	private static final long serialVersionUID = 1L;
	
	@Override
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		javax.servlet.http.Cookie userCookie = new javax.servlet.http.Cookie("BenchmarkTest01841", "FileName");
		userCookie.setMaxAge(60*3); //Store cookie for 3 minutes
		userCookie.setSecure(true);
		userCookie.setPath(request.getRequestURI());
		response.addCookie(userCookie);
		javax.servlet.RequestDispatcher rd = request.getRequestDispatcher("/pathtraver-02/BenchmarkTest01841.html");
		rd.include(request, response);
	}

	@Override
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html;charset=UTF-8");

		javax.servlet.http.Cookie[] theCookies = request.getCookies();
		
		String param = "noCookieValueSupplied";
		if (theCookies != null) {
			for (javax.servlet.http.Cookie theCookie : theCookies) {
				if (theCookie.getName().equals("BenchmarkTest01841")) {
					param = java.net.URLDecoder.decode(theCookie.getValue(), "UTF-8");
					break;
				}
			}
		}

		String bar = doSomething(request, param);
		
		String fileName = null;
		java.io.FileOutputStream fos = null;

		try {
			// Create the file first so the test won't throw an exception if it doesn't exist.
			// Note: Don't actually do this because this method signature could cause a tool to find THIS file constructor 
			// as a vuln, rather than the File signature we are trying to actually test.
			// If necessary, just run the benchmark twice. The 1st run should create all the necessary files.
			//new java.io.File(org.owasp.benchmark.helpers.Utils.testfileDir + bar).createNewFile();
			
			fileName = org.owasp.benchmark.helpers.Utils.testfileDir + bar;
	
	
	        java.io.FileInputStream fileInputStream = new java.io.FileInputStream(fileName);
	        java.io.FileDescriptor fd = fileInputStream.getFD();
	        fos = new java.io.FileOutputStream(fd);
	        response.getWriter().println(
			"Now ready to write to file: " + org.owasp.esapi.ESAPI.encoder().encodeForHTML(fileName)
);

		} catch (Exception e) {
			System.out.println("Couldn't open FileOutputStream on file: '" + fileName + "'");
//			System.out.println("File exception caught and swallowed: " + e.getMessage());
		} finally {
			if (fos != null) {
				try {
					fos.close();
                    fos = null;
				} catch (Exception e) {
					// we tried...
				}
			}
		}
	}  // end doPost
	
		
	private static String doSomething(HttpServletRequest request, String param) throws ServletException, IOException {

		// Chain a bunch of propagators in sequence
		String a14546 = param; //assign
		StringBuilder b14546 = new StringBuilder(a14546);  // stick in stringbuilder
		b14546.append(" SafeStuff"); // append some safe content
		b14546.replace(b14546.length()-"Chars".length(),b14546.length(),"Chars"); //replace some of the end content
		java.util.HashMap<String,Object> map14546 = new java.util.HashMap<String,Object>();
		map14546.put("key14546", b14546.toString()); // put in a collection
		String c14546 = (String)map14546.get("key14546"); // get it back out
		String d14546 = c14546.substring(0,c14546.length()-1); // extract most of it
		String e14546 = new String( org.apache.commons.codec.binary.Base64.decodeBase64(
		    org.apache.commons.codec.binary.Base64.encodeBase64( d14546.getBytes() ) )); // B64 encode and decode it
		String f14546 = e14546.split(" ")[0]; // split it on a space
		org.owasp.benchmark.helpers.ThingInterface thing = org.owasp.benchmark.helpers.ThingFactory.createThing();
		String g14546 = "barbarians_at_the_gate";  // This is static so this whole flow is 'safe'
		String bar = thing.doSomething(g14546); // reflection
	
		return bar;	
	}
}
