/**
* OWASP Benchmark Project v1.2
*
* This file is part of the Open Web Application Security Project (OWASP)
* Benchmark Project. For details, please see
* <a href="https://www.owasp.org/index.php/Benchmark">https://www.owasp.org/index.php/Benchmark</a>.
*
* The OWASP Benchmark is free software: you can redistribute it and/or modify it under the terms
* of the GNU General Public License as published by the Free Software Foundation, version 2.
*
* The OWASP Benchmark is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* @author Nick Sanidas <a href="https://www.aspectsecurity.com">Aspect Security</a>
* @created 2015
*/

package org.owasp.benchmark.testcode;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value="/pathtraver-00/BenchmarkTest00456")
public class BenchmarkTest00456 extends HttpServlet {
	
	private static final long serialVersionUID = 1L;
	
	@Override
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doPost(request, response);
	}

	@Override
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html;charset=UTF-8");
	
		java.util.Map<String,String[]> map = request.getParameterMap();
		String param = "";
		if (!map.isEmpty()) {
			String[] values = map.get("BenchmarkTest00456");
			if (values != null) param = values[0];
		}
		
		
		
		String bar = "safe!";
		java.util.HashMap<String,Object> map49381 = new java.util.HashMap<String,Object>();
		map49381.put("keyA-49381", "a-Value"); // put some stuff in the collection
		map49381.put("keyB-49381", param); // put it in a collection
		map49381.put("keyC", "another-Value"); // put some stuff in the collection
		bar = (String)map49381.get("keyB-49381"); // get it back out
		
		
		String fileName = null;
		java.io.FileInputStream fis = null;

		try {
			fileName = org.owasp.benchmark.helpers.Utils.testfileDir + bar;
			fis = new java.io.FileInputStream(fileName);
			byte[] b = new byte[1000];
			int size = fis.read(b);
			response.getWriter().println(
"The beginning of file: '" + org.owasp.esapi.ESAPI.encoder().encodeForHTML(fileName) + "' is:\n\n"
);
			response.getWriter().println(
org.owasp.esapi.ESAPI.encoder().encodeForHTML(new String(b,0,size))
);
		} catch (Exception e) {
			System.out.println("Couldn't open FileInputStream on file: '" + fileName + "'");
//			System.out.println("File exception caught and swallowed: " + e.getMessage());
		} finally {
			if (fis != null) {
				try {
					fis.close();
                    fis = null;
				} catch (Exception e) {
					// we tried...
				}
			}
		}
	}
	
}
