/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonIndexCursor<K, E, ID>
extends AbstractIndexCursor<K, E, ID> {
    private boolean beforeFirst = true;
    private boolean afterLast;
    private boolean onSingleton;
    private final IndexEntry<K, E, ID> singleton;

    public SingletonIndexCursor(IndexEntry<K, E, ID> singleton) {
        this.singleton = singleton;
    }

    public boolean available() {
        return this.onSingleton;
    }

    public void before(IndexEntry<K, E, ID> element) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeValue(ID id, K value) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterValue(ID id, K value) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void after(IndexEntry<K, E, ID> element) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = true;
        this.afterLast = false;
        this.onSingleton = false;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.afterLast = true;
        this.onSingleton = false;
    }

    public boolean first() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    public boolean last() throws Exception {
        this.checkNotClosed("()");
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    public boolean isFirst() throws Exception {
        this.checkNotClosed("()");
        return this.onSingleton;
    }

    public boolean isLast() throws Exception {
        this.checkNotClosed("()");
        return this.onSingleton;
    }

    public boolean isAfterLast() throws Exception {
        this.checkNotClosed("()");
        return this.afterLast;
    }

    public boolean isBeforeFirst() throws Exception {
        this.checkNotClosed("()");
        return this.beforeFirst;
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("()");
        if (this.beforeFirst) {
            return false;
        }
        if (this.afterLast) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        this.beforeFirst = true;
        this.onSingleton = false;
        this.afterLast = false;
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("()");
        if (this.beforeFirst) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        if (this.afterLast) {
            return false;
        }
        this.beforeFirst = false;
        this.onSingleton = false;
        this.afterLast = true;
        return false;
    }

    public IndexEntry<K, E, ID> get() throws Exception {
        this.checkNotClosed("()");
        if (this.onSingleton) {
            return this.singleton;
        }
        if (this.beforeFirst) {
            throw new InvalidCursorPositionException(I18n.err((String)I18n.ERR_705, (Object[])new Object[0]));
        }
        throw new InvalidCursorPositionException(I18n.err((String)I18n.ERR_706, (Object[])new Object[0]));
    }

    public boolean isElementReused() {
        return true;
    }
}

