/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionKey
extends AbstractAsn1Object {
    private static final Logger log = LoggerFactory.getLogger(EncryptionKey.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private EncryptionType keyType;
    private byte[] keyValue;
    private int keyVersion;
    private transient int keyTypeLength;
    private transient int keyValueLength;
    private transient int encryptionKeyLength;

    public EncryptionKey() {
    }

    public EncryptionKey(EncryptionType keyType, byte[] keyValue) {
        this.keyType = keyType;
        this.keyValue = keyValue;
    }

    public EncryptionKey(EncryptionType keyType, byte[] keyValue, int keyVersion) {
        this.keyType = keyType;
        this.keyValue = keyValue;
        this.keyVersion = keyVersion;
    }

    public synchronized void destroy() {
        if (this.keyValue != null) {
            Arrays.fill(this.keyValue, (byte)0);
        }
    }

    public EncryptionType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(EncryptionType keyType) {
        this.keyType = keyType;
    }

    public byte[] getKeyValue() {
        return this.keyValue;
    }

    public int getKeyVersion() {
        return this.keyVersion;
    }

    public void setKeyVersion(int keyVersion) {
        this.keyVersion = keyVersion;
    }

    public void setKeyValue(byte[] keyValue) {
        this.keyValue = keyValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey that = (EncryptionKey)((Object)o);
        return this.keyType == that.keyType && Arrays.equals(this.keyValue, that.keyValue);
    }

    public int computeLength() {
        this.keyTypeLength = 2 + Value.getNbBytes((int)this.keyType.getOrdinal());
        this.encryptionKeyLength = 1 + TLV.getNbBytes((int)this.keyTypeLength) + this.keyTypeLength;
        this.keyValueLength = this.keyValue == null ? 2 : 1 + TLV.getNbBytes((int)this.keyValue.length) + this.keyValue.length;
        this.encryptionKeyLength += 1 + TLV.getNbBytes((int)this.keyValueLength) + this.keyValueLength;
        int encryptionKeySeqLength = 1 + Value.getNbBytes((int)this.encryptionKeyLength) + this.encryptionKeyLength;
        return encryptionKeySeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((String)I18n.ERR_148, (Object[])new Object[0]));
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.encryptionKeyLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.keyTypeLength));
            Value.encode((ByteBuffer)buffer, (int)this.keyType.getOrdinal());
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.keyValueLength));
            Value.encode((ByteBuffer)buffer, (byte[])this.keyValue);
        }
        catch (BufferOverflowException boe) {
            log.error(I18n.err((String)I18n.ERR_142, (Object[])new Object[]{1 + TLV.getNbBytes((int)this.encryptionKeyLength) + this.encryptionKeyLength, buffer.capacity()}));
            throw new EncoderException(I18n.err((String)I18n.ERR_138, (Object[])new Object[0]));
        }
        if (IS_DEBUG) {
            log.debug("EncryptionKey encoding : {}", (Object)StringTools.dumpBytes((byte[])buffer.array()));
            log.debug("EncryptionKey initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        return this.keyType.toString() + " (" + this.keyType.getOrdinal() + ")";
    }
}

