/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.directory.server.core.avltree.Marshaller;
import org.apache.directory.server.i18n.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMarshaller
implements Marshaller<Object> {
    public static final DefaultMarshaller INSTANCE = new DefaultMarshaller();

    @Override
    public byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteStream);
        out.writeObject(object);
        out.flush();
        byte[] data = byteStream.toByteArray();
        out.close();
        return data;
    }

    @Override
    public Object deserialize(byte[] bytes) throws IOException {
        Object object;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(byteStream);
        try {
            object = in.readObject();
        }
        catch (ClassNotFoundException e) {
            IOException ioe = new IOException(I18n.err((String)I18n.ERR_445, (Object[])new Object[0]));
            ioe.initCause(e);
            throw ioe;
        }
        return object;
    }
}

