/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.LessEqEvaluator;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.entry.ServerEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessEqCursor<V, ID>
extends AbstractIndexCursor<V, ServerEntry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err((String)I18n.ERR_716, (Object[])new Object[0]);
    private final LessEqEvaluator<V, ID> lessEqEvaluator;
    private final IndexCursor<V, ServerEntry, ID> userIdxCursor;
    private final IndexCursor<V, ServerEntry, ID> ndnIdxCursor;
    IndexEntry<V, ServerEntry, ID> ndnCandidate;
    private boolean available = false;

    public LessEqCursor(Store<ServerEntry, ID> db, LessEqEvaluator<V, ID> lessEqEvaluator) throws Exception {
        this.lessEqEvaluator = lessEqEvaluator;
        String attribute = lessEqEvaluator.getExpression().getAttribute();
        if (db.hasIndexOn(attribute)) {
            this.userIdxCursor = db.getIndex(attribute).forwardCursor();
            this.ndnIdxCursor = null;
        } else {
            this.ndnIdxCursor = db.getNdnIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    public boolean available() {
        return this.available;
    }

    public void beforeValue(ID id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor != null) {
            int compareValue = this.lessEqEvaluator.getLdapComparator().compare(value, this.lessEqEvaluator.getExpression().getValue().get());
            if (compareValue > 0) {
                this.afterLast();
                return;
            }
            if (compareValue == 0) {
                this.last();
                this.previous();
                this.available = false;
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.beforeValue(id, value);
        this.available = false;
    }

    public void before(IndexEntry<V, ServerEntry, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor != null) {
            int compareValue = this.lessEqEvaluator.getLdapComparator().compare(element.getValue(), this.lessEqEvaluator.getExpression().getValue().get());
            if (compareValue > 0) {
                this.afterLast();
                return;
            }
            if (compareValue == 0) {
                this.last();
                this.previous();
                this.available = false;
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.before(element);
        this.available = false;
    }

    public void afterValue(ID id, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.lessEqEvaluator.getLdapComparator().compare(value, this.lessEqEvaluator.getExpression().getValue().get());
            if (comparedValue >= 0) {
                this.afterLast();
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.afterValue(id, value);
        this.available = false;
    }

    public void after(IndexEntry<V, ServerEntry, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.lessEqEvaluator.getLdapComparator().compare(element.getValue(), this.lessEqEvaluator.getExpression().getValue().get());
            if (comparedValue >= 0) {
                this.afterLast();
                return;
            }
        } else {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.after(element);
        this.available = false;
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeFirst();
        } else {
            this.ndnIdxCursor.beforeFirst();
            this.ndnCandidate = null;
        }
        this.available = false;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            ForwardIndexEntry advanceTo = new ForwardIndexEntry();
            advanceTo.setValue(this.lessEqEvaluator.getExpression().getValue().get());
            this.userIdxCursor.after((Object)advanceTo);
        } else {
            this.ndnIdxCursor.afterLast();
            this.ndnCandidate = null;
        }
        this.available = false;
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.userIdxCursor != null) {
            this.available = this.userIdxCursor.previous();
            return this.available;
        }
        while (this.ndnIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            this.ndnCandidate = (IndexEntry)this.ndnIdxCursor.get();
            if (this.lessEqEvaluator.evaluate(this.ndnCandidate)) {
                this.available = true;
                return true;
            }
            this.ndnCandidate = null;
        }
        this.available = false;
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.userIdxCursor != null) {
            while (this.userIdxCursor.next()) {
                this.checkNotClosed("next()");
                IndexEntry candidate = (IndexEntry)this.userIdxCursor.get();
                if (this.lessEqEvaluator.getLdapComparator().compare(candidate.getValue(), this.lessEqEvaluator.getExpression().getValue().get()) > 0) continue;
                this.available = true;
                return true;
            }
            this.available = false;
            return false;
        }
        while (this.ndnIdxCursor.next()) {
            this.checkNotClosed("next()");
            this.ndnCandidate = (IndexEntry)this.ndnIdxCursor.get();
            if (this.lessEqEvaluator.evaluate(this.ndnCandidate)) {
                this.available = true;
                return true;
            }
            this.ndnCandidate = null;
        }
        this.available = false;
        return false;
    }

    public IndexEntry<V, ServerEntry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            if (this.available) {
                return (IndexEntry)this.userIdxCursor.get();
            }
            throw new InvalidCursorPositionException(I18n.err((String)I18n.ERR_708, (Object[])new Object[0]));
        }
        if (this.available) {
            return this.ndnCandidate;
        }
        throw new InvalidCursorPositionException(I18n.err((String)I18n.ERR_708, (Object[])new Object[0]));
    }

    public boolean isElementReused() {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.isElementReused();
        }
        return this.ndnIdxCursor.isElementReused();
    }

    public void close() throws Exception {
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.ndnIdxCursor.close();
            this.ndnCandidate = null;
        }
    }
}

