/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.cursor.CursorIterator;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockCursor
implements Cursor<ServerEntry> {
    final int count;
    int ii;
    SchemaManager schemaManager;

    public MockCursor(int count) {
        this.count = count;
    }

    public boolean available() {
        return this.ii < this.count;
    }

    public void close() throws NamingException {
        this.ii = this.count;
    }

    public boolean hasMoreElements() {
        return this.ii < this.count;
    }

    public Object nextElement() {
        if (this.ii >= this.count) {
            throw new NoSuchElementException();
        }
        ++this.ii;
        return new Object();
    }

    public void after(ServerEntry element) throws Exception {
    }

    public void afterLast() throws Exception {
    }

    public void before(ServerEntry element) throws Exception {
        throw new NotImplementedException();
    }

    public void beforeFirst() throws Exception {
        this.ii = -1;
    }

    public boolean first() throws Exception {
        this.ii = 0;
        return this.ii < this.count;
    }

    public ServerEntry get() throws Exception {
        return new DefaultServerEntry(this.schemaManager);
    }

    public boolean isClosed() throws Exception {
        return false;
    }

    public boolean isElementReused() {
        return false;
    }

    public boolean last() throws Exception {
        this.ii = this.count;
        return true;
    }

    public boolean next() {
        if (this.ii >= this.count) {
            return false;
        }
        ++this.ii;
        return true;
    }

    public boolean previous() throws Exception {
        if (this.ii < 0) {
            return false;
        }
        --this.ii;
        return true;
    }

    public Iterator<ServerEntry> iterator() {
        return new CursorIterator((Cursor)this);
    }

    public void close(Exception reason) throws Exception {
    }

    public void setClosureMonitor(ClosureMonitor monitor) {
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

