/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.ldif;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.partition.avl.AvlStore;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifStore<E>
implements Store<E, Long> {
    private File workingDirectory;
    private boolean isSyncOnWrite = true;
    private AvlStore<E> wrappedStore = new AvlStore();
    private SchemaManager schemaManager;
    private LdifReader ldifReader;
    private FileFilter dirFilter = new FileFilter(){

        public boolean accept(File dir) {
            return dir.isDirectory();
        }
    };
    private static final String CONF_FILE_EXTN = ".ldif";
    private static Logger LOG = LoggerFactory.getLogger(LdifStore.class);

    public void init(SchemaManager schemaManager) throws Exception {
        this.schemaManager = schemaManager;
        this.wrappedStore.init(schemaManager);
        this.loadConfig();
    }

    public void loadConfig() throws Exception {
        String upsuffixDir = this.wrappedStore.getUpSuffix().getName().toLowerCase();
        File dir = new File(this.workingDirectory, upsuffixDir);
        if (!dir.exists()) {
            throw new Exception(I18n.err((String)I18n.ERR_631, (Object[])new Object[]{upsuffixDir, this.workingDirectory.getAbsolutePath()}));
        }
        this.loadEntry(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntry(File entryDir) throws Exception {
        LOG.debug("processing dir {}", (Object)entryDir.getName());
        File ldifFile = new File(entryDir, entryDir.getName() + CONF_FILE_EXTN);
        try {
            this.ldifReader = new LdifReader();
            if (ldifFile.exists()) {
                LOG.debug("parsing ldif file {}", (Object)ldifFile.getName());
                List entries = this.ldifReader.parseLdifFile(ldifFile.getAbsolutePath());
                if (entries != null && !entries.isEmpty()) {
                    LdifEntry ldifEntry = (LdifEntry)entries.get(0);
                    LOG.debug("adding entry {}", (Object)ldifEntry);
                    DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, ldifEntry.getEntry());
                    this.wrappedStore.add((ServerEntry)serverEntry);
                }
            } else {
                LOG.warn("ldif file doesn't exist {}", (Object)ldifFile.getAbsolutePath());
            }
        }
        finally {
            this.ldifReader.close();
        }
        File[] dirs = entryDir.listFiles(this.dirFilter);
        if (dirs != null) {
            for (File f : dirs) {
                this.loadEntry(f);
            }
        }
    }

    private File getFile(DN entryDn) {
        int size = entryDn.size();
        StringBuilder filePath = new StringBuilder();
        filePath.append(this.workingDirectory.getAbsolutePath()).append(File.separator);
        for (int i = 0; i < size; ++i) {
            filePath.append(entryDn.getRdn(i).getName().toLowerCase()).append(File.separator);
        }
        File dir = new File(filePath.toString());
        dir.mkdirs();
        return new File(dir, entryDn.getRdn().getName().toLowerCase() + CONF_FILE_EXTN);
    }

    public void add(ServerEntry entry) throws Exception {
        this.wrappedStore.add(entry);
        FileWriter fw = new FileWriter(this.getFile(entry.getDn()));
        fw.write(LdifUtils.convertEntryToLdif((Entry)entry));
        fw.close();
    }

    public void delete(Long id) throws Exception {
        ServerEntry entry = this.lookup(id);
        LOG.warn("deleting the entry with id {} and dn {}", (Object)id, (Object)entry.getDn());
        LOG.warn("having the parent id {}", (Object)this.getParentId(entry.getDn().getName()));
        this.wrappedStore.delete(id);
        if (entry != null) {
            File file = this.getFile(entry.getDn()).getParentFile();
            boolean deleted = this.deleteFile(file);
            LOG.warn("deleted file {} {}", (Object)file.getAbsoluteFile(), (Object)deleted);
        }
    }

    private boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.deleteFile(f);
            }
        }
        return file.delete();
    }

    public void destroy() throws Exception {
        this.wrappedStore.destroy();
    }

    public void modify(DN dn, List<Modification> mods) throws Exception {
        this.wrappedStore.modify(dn, mods);
    }

    public void modify(DN dn, ModificationOperation modOp, ServerEntry mods) throws Exception {
        this.wrappedStore.modify(dn, modOp, mods);
    }

    public void move(DN oldChildDn, DN newParentDn, RDN newRdn, boolean deleteOldRdn) throws Exception {
        this.wrappedStore.move(oldChildDn, newParentDn, newRdn, deleteOldRdn);
    }

    public void move(DN oldChildDn, DN newParentDn) throws Exception {
        this.wrappedStore.move(oldChildDn, newParentDn);
    }

    public void rename(DN dn, RDN newRdn, boolean deleteOldRdn) throws Exception {
        this.wrappedStore.rename(dn, newRdn, deleteOldRdn);
    }

    public void sync() throws Exception {
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setSyncOnWrite(boolean isSyncOnWrite) {
        this.isSyncOnWrite = isSyncOnWrite;
    }

    public boolean isSyncOnWrite() {
        return this.isSyncOnWrite;
    }

    public void addIndex(Index<?, E, Long> index) throws Exception {
        this.wrappedStore.addIndex(index);
    }

    public int count() throws Exception {
        return this.wrappedStore.count();
    }

    public Index<String, E, Long> getAliasIndex() {
        return this.wrappedStore.getAliasIndex();
    }

    public int getChildCount(Long id) throws Exception {
        return this.wrappedStore.getChildCount(id);
    }

    public String getEntryDn(Long id) throws Exception {
        return this.wrappedStore.getEntryDn(id);
    }

    public Long getEntryId(String dn) throws Exception {
        return this.wrappedStore.getEntryId(dn);
    }

    public String getEntryUpdn(Long arg0) throws Exception {
        return this.wrappedStore.getEntryUpdn(arg0);
    }

    public String getEntryUpdn(String dn) throws Exception {
        return this.wrappedStore.getEntryUpdn(dn);
    }

    public String getName() {
        return this.wrappedStore.getName();
    }

    public Index<String, E, Long> getNdnIndex() {
        return this.wrappedStore.getNdnIndex();
    }

    public Index<Long, E, Long> getOneAliasIndex() {
        return this.wrappedStore.getOneAliasIndex();
    }

    public Index<Long, E, Long> getOneLevelIndex() {
        return this.wrappedStore.getOneLevelIndex();
    }

    public Long getParentId(Long arg0) throws Exception {
        return this.wrappedStore.getParentId(arg0);
    }

    public Long getParentId(String dn) throws Exception {
        return this.wrappedStore.getParentId(dn);
    }

    public Index<String, E, Long> getPresenceIndex() {
        return this.wrappedStore.getPresenceIndex();
    }

    public String getProperty(String propertyName) throws Exception {
        return this.wrappedStore.getProperty(propertyName);
    }

    public Index<Long, E, Long> getSubAliasIndex() {
        return this.wrappedStore.getSubAliasIndex();
    }

    public Index<Long, E, Long> getSubLevelIndex() {
        return this.wrappedStore.getSubLevelIndex();
    }

    public Index<?, E, Long> getIndex(String id) throws IndexNotFoundException {
        return this.wrappedStore.getIndex(id);
    }

    public Index<?, E, Long> getSystemIndex(String id) throws IndexNotFoundException {
        return this.wrappedStore.getSystemIndex(id);
    }

    public Index<String, E, Long> getUpdnIndex() {
        return this.wrappedStore.getUpdnIndex();
    }

    public Index<?, E, Long> getUserIndex(String id) throws IndexNotFoundException {
        return this.wrappedStore.getUserIndex(id);
    }

    public Set<Index<?, E, Long>> getUserIndices() {
        return this.wrappedStore.getUserIndices();
    }

    public boolean hasIndexOn(String id) throws Exception {
        return this.wrappedStore.hasIndexOn(id);
    }

    public boolean hasSystemIndexOn(String id) throws Exception {
        return this.wrappedStore.hasSystemIndexOn(id);
    }

    public boolean hasUserIndexOn(String id) throws Exception {
        return this.wrappedStore.hasUserIndexOn(id);
    }

    public boolean isInitialized() {
        return this.wrappedStore.isInitialized();
    }

    public IndexCursor<Long, E, Long> list(Long id) throws Exception {
        return this.wrappedStore.list(id);
    }

    public ServerEntry lookup(Long id) throws Exception {
        return this.wrappedStore.lookup(id);
    }

    public void setAliasIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setAliasIndex(index);
    }

    public void setName(String name) {
        this.wrappedStore.setName(name);
    }

    public void setNdnIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setNdnIndex(index);
    }

    public void setOneAliasIndex(Index<Long, E, Long> index) throws Exception {
        this.wrappedStore.setOneAliasIndex(index);
    }

    public void setOneLevelIndex(Index<Long, E, Long> index) throws Exception {
        this.wrappedStore.setOneLevelIndex(index);
    }

    public void setPresenceIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setPresenceIndex(index);
    }

    public void setProperty(String propertyName, String propertyValue) throws Exception {
        this.wrappedStore.setProperty(propertyName, propertyValue);
    }

    public void setSubAliasIndex(Index<Long, E, Long> index) throws Exception {
        this.wrappedStore.setSubAliasIndex(index);
    }

    public void setSubLevelIndex(Index<Long, E, Long> index) throws Exception {
        this.wrappedStore.setSubLevelIndex(index);
    }

    public void setUpdnIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setUpdnIndex(index);
    }

    public Iterator<String> systemIndices() {
        return this.wrappedStore.systemIndices();
    }

    public Iterator<String> userIndices() {
        return this.wrappedStore.userIndices();
    }

    public int getCacheSize() {
        return this.wrappedStore.getCacheSize();
    }

    public Index<String, E, Long> getEntryCsnIndex() {
        return this.wrappedStore.getEntryCsnIndex();
    }

    public Index<String, E, Long> getEntryUuidIndex() {
        return this.wrappedStore.getEntryUuidIndex();
    }

    public Index<String, E, Long> getObjectClassIndex() {
        return this.wrappedStore.getObjectClassIndex();
    }

    public DN getSuffix() {
        return this.wrappedStore.getSuffix();
    }

    public String getSuffixDn() {
        return this.wrappedStore.getSuffixDn();
    }

    public DN getUpSuffix() {
        return this.wrappedStore.getUpSuffix();
    }

    public void setCacheSize(int size) {
        this.wrappedStore.setCacheSize(size);
    }

    public void setUserIndices(Set<Index<?, E, Long>> userIndices) {
        this.wrappedStore.setUserIndices(userIndices);
    }

    public void setSuffixDn(String suffixDn) {
        this.wrappedStore.setSuffixDn(suffixDn);
    }

    public void setEntryCsnIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setEntryCsnIndex(index);
    }

    public void setEntryUuidIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setEntryUuidIndex(index);
    }

    public void setObjectClassIndex(Index<String, E, Long> index) throws Exception {
        this.wrappedStore.setObjectClassIndex(index);
    }

    public Long getDefaultId() {
        return 1L;
    }
}

