/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.constants.SchemaConstants;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.internal.InternalSearchRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchOperationContext
extends SearchingOperationContext {
    private ExprNode filter;

    public SearchOperationContext(CoreSession session) {
        super(session);
    }

    public SearchOperationContext(CoreSession session, InternalSearchRequest searchRequest) throws Exception {
        super(session);
        this.dn = searchRequest.getBase();
        this.filter = searchRequest.getFilter();
        this.abandoned = searchRequest.isAbandoned();
        this.aliasDerefMode = searchRequest.getDerefAliases();
        this.requestControls = searchRequest.getControls();
        this.scope = searchRequest.getScope();
        this.sizeLimit = searchRequest.getSizeLimit();
        this.timeLimit = searchRequest.getTimeLimit();
        this.typesOnly = searchRequest.getTypesOnly();
        this.setReturningAttributes(searchRequest.getAttributes());
        this.throwReferral = !this.requestControls.containsKey("2.16.840.1.113730.3.4.2");
    }

    public SearchOperationContext(CoreSession session, DN dn, ExprNode filter, SearchControls searchControls) throws Exception {
        super(session, dn);
        this.filter = filter;
        this.scope = SearchScope.getSearchScope((int)searchControls.getSearchScope());
        this.timeLimit = searchControls.getTimeLimit();
        this.sizeLimit = searchControls.getCountLimit();
        this.typesOnly = searchControls.getReturningObjFlag();
        if (searchControls.getReturningAttributes() != null) {
            this.setReturningAttributes(searchControls.getReturningAttributes());
        } else {
            this.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        }
    }

    public SearchOperationContext(CoreSession session, DN dn, SearchScope scope, ExprNode filter, Set<AttributeTypeOptions> returningAttributes) {
        super(session, dn, returningAttributes);
        super.setScope(scope);
        this.filter = filter;
    }

    public boolean hasManageDsaItControl() {
        return super.hasRequestControl("2.16.840.1.113730.3.4.2");
    }

    public ExprNode getFilter() {
        return this.filter;
    }

    public void setFilter(ExprNode filter) {
        this.filter = filter;
    }

    @Override
    public String toString() {
        return "SearchContext for DN '" + this.getDn().getName() + "', filter :'" + this.filter + "'";
    }

    @Override
    public String getName() {
        return MessageTypeEnum.SEARCH_REQUEST.name();
    }
}

