/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.entry.DefaultServerEntry;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.message.internal.InternalAddRequest;
import org.apache.directory.shared.ldap.name.DN;

public class AddOperationContext
extends AbstractChangeOperationContext {
    public AddOperationContext(CoreSession session) {
        super(session);
    }

    public AddOperationContext(CoreSession session, DN dn) {
        super(session, dn);
    }

    public AddOperationContext(CoreSession session, ServerEntry entry) {
        super(session, entry.getDn());
        this.entry = new ClonedServerEntry(entry);
    }

    public AddOperationContext(CoreSession session, DN dn, ServerEntry entry) {
        super(session, dn);
        this.entry = new ClonedServerEntry(entry);
    }

    public AddOperationContext(CoreSession session, InternalAddRequest addRequest) throws Exception {
        super(session);
        this.entry = new ClonedServerEntry((ServerEntry)new DefaultServerEntry(session.getDirectoryService().getSchemaManager(), addRequest.getEntry()));
        this.dn = addRequest.getEntry().getDn();
        this.requestControls = addRequest.getControls();
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public String getName() {
        return MessageTypeEnum.ADD_REQUEST.name();
    }

    public String toString() {
        return "AddContext for DN '" + this.getDn().getName() + "'" + ", added entry: " + this.entry;
    }
}

