/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.sp.StoredProcEngine;
import org.apache.directory.server.core.sp.StoredProcEngineConfig;
import org.apache.directory.server.core.sp.StoredProcExecutionManager;
import org.apache.directory.server.core.sp.java.JavaStoredProcEngineConfig;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.core.trigger.AddStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.DeleteStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.ModifyDNStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.ModifyStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.SimpleTriggerExecutionAuthorizer;
import org.apache.directory.server.core.trigger.StoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.TriggerExecutionAuthorizer;
import org.apache.directory.server.core.trigger.TriggerSpecCache;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapOperationErrorException;
import org.apache.directory.shared.ldap.exception.LdapOtherException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.trigger.ActionTime;
import org.apache.directory.shared.ldap.trigger.LdapOperation;
import org.apache.directory.shared.ldap.trigger.TriggerSpecification;
import org.apache.directory.shared.ldap.trigger.TriggerSpecificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(TriggerInterceptor.class);
    private static final String ENTRY_TRIGGER_ATTR = "entryTriggerSpecification";
    private TriggerSpecCache triggerSpecCache;
    private TriggerSpecificationParser triggerParser;
    private InterceptorChain chain;
    private boolean enabled = true;
    private TriggerExecutionAuthorizer triggerExecutionAuthorizer = new SimpleTriggerExecutionAuthorizer();
    private StoredProcExecutionManager manager;

    private void addPrescriptiveTriggerSpecs(OperationContext opContext, List<TriggerSpecification> triggerSpecs, DN dn, ServerEntry entry) throws Exception {
        EntryAttribute subentries;
        if (entry.contains("objectClass", new String[]{"subentry"})) {
            DN parentDn = (DN)dn.clone();
            parentDn.remove(dn.size() - 1);
            entry = opContext.lookup(parentDn, ByPassConstants.LOOKUP_BYPASS);
        }
        if ((subentries = entry.get("triggerExecutionSubentries")) == null) {
            return;
        }
        for (Value value : subentries) {
            String subentryDn = value.getString();
            triggerSpecs.addAll(this.triggerSpecCache.getSubentryTriggerSpecs(subentryDn));
        }
    }

    private void addEntryTriggerSpecs(List<TriggerSpecification> triggerSpecs, ServerEntry entry) throws Exception {
        EntryAttribute entryTrigger = entry.get(ENTRY_TRIGGER_ATTR);
        if (entryTrigger == null) {
            return;
        }
        for (Value value : entryTrigger) {
            TriggerSpecification item;
            String triggerString = value.getString();
            try {
                item = this.triggerParser.parse(triggerString);
            }
            catch (ParseException e) {
                String msg = I18n.err((String)I18n.ERR_72, (Object[])new Object[]{triggerString});
                LOG.error(msg, (Throwable)e);
                throw new LdapOperationErrorException(msg);
            }
            triggerSpecs.add(item);
        }
    }

    public Map<ActionTime, List<TriggerSpecification>> getActionTimeMappedTriggerSpecsForOperation(List<TriggerSpecification> triggerSpecs, LdapOperation ldapOperation) {
        ArrayList<TriggerSpecification> afterTriggerSpecs = new ArrayList<TriggerSpecification>();
        HashMap<ActionTime, List<TriggerSpecification>> triggerSpecMap = new HashMap<ActionTime, List<TriggerSpecification>>();
        for (TriggerSpecification triggerSpec : triggerSpecs) {
            if (!triggerSpec.getLdapOperation().equals((Object)ldapOperation) || !triggerSpec.getActionTime().equals((Object)ActionTime.AFTER)) continue;
            afterTriggerSpecs.add(triggerSpec);
        }
        triggerSpecMap.put(ActionTime.AFTER, afterTriggerSpecs);
        return triggerSpecMap;
    }

    public void init(DirectoryService directoryService) throws Exception {
        super.init(directoryService);
        this.triggerSpecCache = new TriggerSpecCache(directoryService);
        final SchemaManager schemaManager = directoryService.getSchemaManager();
        this.triggerParser = new TriggerSpecificationParser(new NormalizerMappingResolver(){

            public Map<String, OidNormalizer> getNormalizerMapping() throws Exception {
                return schemaManager.getNormalizerMapping();
            }
        });
        this.chain = directoryService.getInterceptorChain();
        JavaStoredProcEngineConfig javaSPEngineConfig = new JavaStoredProcEngineConfig();
        ArrayList<StoredProcEngineConfig> spEngineConfigs = new ArrayList<StoredProcEngineConfig>();
        spEngineConfigs.add(javaSPEngineConfig);
        String spContainer = "ou=Stored Procedures,ou=system";
        this.manager = new StoredProcExecutionManager(spContainer, spEngineConfigs);
        this.enabled = true;
    }

    public void add(NextInterceptor next, AddOperationContext addContext) throws Exception {
        DN name = addContext.getDn();
        ClonedServerEntry entry = addContext.getEntry();
        if (!this.enabled) {
            next.add(addContext);
            return;
        }
        AddStoredProcedureParameterInjector injector = new AddStoredProcedureParameterInjector((OperationContext)addContext, name, (ServerEntry)entry);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)addContext, triggerSpecs, name, (ServerEntry)entry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.ADD);
        next.add(addContext);
        this.triggerSpecCache.subentryAdded(name, (ServerEntry)entry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)addContext, afterTriggerSpecs, injector);
    }

    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws Exception {
        DN name = deleteContext.getDn();
        if (!this.enabled) {
            next.delete(deleteContext);
            return;
        }
        ClonedServerEntry deletedEntry = deleteContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        DeleteStoredProcedureParameterInjector injector = new DeleteStoredProcedureParameterInjector((OperationContext)deleteContext, name);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)deleteContext, triggerSpecs, name, (ServerEntry)deletedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, (ServerEntry)deletedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.DELETE);
        next.delete(deleteContext);
        this.triggerSpecCache.subentryDeleted(name, (ServerEntry)deletedEntry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)deleteContext, afterTriggerSpecs, injector);
    }

    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        if (!this.enabled) {
            next.modify(opContext);
            return;
        }
        DN normName = opContext.getDn();
        ClonedServerEntry modifiedEntry = opContext.lookup(normName, ByPassConstants.LOOKUP_BYPASS);
        ModifyStoredProcedureParameterInjector injector = new ModifyStoredProcedureParameterInjector(opContext);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)opContext, triggerSpecs, normName, (ServerEntry)modifiedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, (ServerEntry)modifiedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.MODIFY);
        next.modify(opContext);
        this.triggerSpecCache.subentryModified(opContext, (ServerEntry)modifiedEntry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)opContext, afterTriggerSpecs, injector);
    }

    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws Exception {
        DN name = renameContext.getDn();
        RDN newRdn = renameContext.getNewRdn();
        boolean deleteOldRn = renameContext.getDelOldDn();
        if (!this.enabled) {
            next.rename(renameContext);
            return;
        }
        ServerEntry renamedEntry = (ServerEntry)renameContext.getEntry().getClonedEntry();
        DN oldRDN = new DN(name.getRdn().getName());
        DN oldSuperiorDN = (DN)name.clone();
        oldSuperiorDN.remove(oldSuperiorDN.size() - 1);
        DN newSuperiorDN = (DN)oldSuperiorDN.clone();
        DN oldDN = (DN)name.clone();
        DN newDN = (DN)name.clone();
        newDN.add(newRdn);
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector((OperationContext)renameContext, deleteOldRn, oldRDN, newRdn, oldSuperiorDN, newSuperiorDN, oldDN, newDN);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)renameContext, triggerSpecs, name, renamedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, renamedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.MODIFYDN_RENAME);
        next.rename(renameContext);
        this.triggerSpecCache.subentryRenamed(name, newDN);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)renameContext, afterTriggerSpecs, injector);
    }

    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws Exception {
        DN oriChildName = opContext.getDn();
        DN parent = opContext.getParent();
        RDN newRdn = opContext.getNewRdn();
        boolean deleteOldRn = opContext.getDelOldDn();
        if (!this.enabled) {
            next.moveAndRename(opContext);
            return;
        }
        ClonedServerEntry movedEntry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        DN oldRDN = new DN(oriChildName.getRdn().getName());
        DN oldSuperiorDN = (DN)oriChildName.clone();
        oldSuperiorDN.remove(oldSuperiorDN.size() - 1);
        DN newSuperiorDN = (DN)parent.clone();
        DN oldDN = (DN)oriChildName.clone();
        DN newDN = (DN)parent.clone();
        newDN.add(newRdn.getName());
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector((OperationContext)opContext, deleteOldRn, oldRDN, newRdn, oldSuperiorDN, newSuperiorDN, oldDN, newDN);
        ArrayList<TriggerSpecification> exportTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)opContext, exportTriggerSpecs, oriChildName, (ServerEntry)movedEntry);
        this.addEntryTriggerSpecs(exportTriggerSpecs, (ServerEntry)movedEntry);
        ClonedServerEntry importedEntry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryInterceptor subentryInterceptor = (SubentryInterceptor)this.chain.get(SubentryInterceptor.class.getName());
        ServerEntry fakeImportedEntry = subentryInterceptor.getSubentryAttributes(newDN, (ServerEntry)importedEntry);
        for (EntryAttribute attribute : importedEntry) {
            fakeImportedEntry.put(new EntryAttribute[]{attribute});
        }
        ArrayList<TriggerSpecification> importTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)opContext, importTriggerSpecs, newDN, fakeImportedEntry);
        Map<ActionTime, List<TriggerSpecification>> exportTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(exportTriggerSpecs, LdapOperation.MODIFYDN_EXPORT);
        Map<ActionTime, List<TriggerSpecification>> importTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(importTriggerSpecs, LdapOperation.MODIFYDN_IMPORT);
        next.moveAndRename(opContext);
        this.triggerSpecCache.subentryRenamed(oldDN, newDN);
        List<TriggerSpecification> afterExportTriggerSpecs = exportTriggerMap.get(ActionTime.AFTER);
        List<TriggerSpecification> afterImportTriggerSpecs = importTriggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)opContext, afterExportTriggerSpecs, injector);
        this.executeTriggers((OperationContext)opContext, afterImportTriggerSpecs, injector);
    }

    public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
        if (!this.enabled) {
            next.move(opContext);
            return;
        }
        DN oriChildName = opContext.getDn();
        DN newParentName = opContext.getParent();
        ClonedServerEntry movedEntry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        DN oldRDN = new DN(oriChildName.getRdn().getName());
        RDN newRDN = new RDN(oriChildName.getRdn().getName());
        DN oldSuperiorDN = (DN)oriChildName.clone();
        oldSuperiorDN.remove(oldSuperiorDN.size() - 1);
        DN newSuperiorDN = (DN)newParentName.clone();
        DN oldDN = (DN)oriChildName.clone();
        DN newDN = (DN)newParentName.clone();
        newDN.add(newRDN.getName());
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector((OperationContext)opContext, false, oldRDN, newRDN, oldSuperiorDN, newSuperiorDN, oldDN, newDN);
        ArrayList<TriggerSpecification> exportTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)opContext, exportTriggerSpecs, oriChildName, (ServerEntry)movedEntry);
        this.addEntryTriggerSpecs(exportTriggerSpecs, (ServerEntry)movedEntry);
        ClonedServerEntry importedEntry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryInterceptor subentryInterceptor = (SubentryInterceptor)this.chain.get(SubentryInterceptor.class.getName());
        ServerEntry fakeImportedEntry = subentryInterceptor.getSubentryAttributes(newDN, (ServerEntry)importedEntry);
        for (EntryAttribute attribute : importedEntry) {
            fakeImportedEntry.put(new EntryAttribute[]{attribute});
        }
        ArrayList<TriggerSpecification> importTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)opContext, importTriggerSpecs, newDN, fakeImportedEntry);
        Map<ActionTime, List<TriggerSpecification>> exportTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(exportTriggerSpecs, LdapOperation.MODIFYDN_EXPORT);
        Map<ActionTime, List<TriggerSpecification>> importTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(importTriggerSpecs, LdapOperation.MODIFYDN_IMPORT);
        next.move(opContext);
        this.triggerSpecCache.subentryRenamed(oldDN, newDN);
        List<TriggerSpecification> afterExportTriggerSpecs = exportTriggerMap.get(ActionTime.AFTER);
        List<TriggerSpecification> afterImportTriggerSpecs = importTriggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)opContext, afterExportTriggerSpecs, injector);
        this.executeTriggers((OperationContext)opContext, afterImportTriggerSpecs, injector);
    }

    private Object executeTriggers(OperationContext opContext, List<TriggerSpecification> triggerSpecs, StoredProcedureParameterInjector injector) throws Exception {
        Object result = null;
        for (TriggerSpecification triggerSpec : triggerSpecs) {
            if (!this.triggerExecutionAuthorizer.hasPermission(opContext)) continue;
            result = this.executeTrigger(opContext, triggerSpec, injector);
        }
        return result;
    }

    private Object executeTrigger(OperationContext opContext, TriggerSpecification tsec, StoredProcedureParameterInjector injector) throws Exception {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        List spSpecs = tsec.getSPSpecs();
        for (TriggerSpecification.SPSpec spSpec : spSpecs) {
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.addAll(injector.getArgumentsToInject(opContext, spSpec.getParameters()));
            Object[] values = arguments.toArray();
            Object returnValue = this.executeProcedure(opContext, spSpec.getName(), values);
            returnValues.add(returnValue);
        }
        return returnValues;
    }

    private Object executeProcedure(OperationContext opContext, String procedure, Object[] values) throws Exception {
        try {
            ClonedServerEntry spUnit = this.manager.findStoredProcUnit(opContext.getSession(), procedure);
            StoredProcEngine engine = this.manager.getStoredProcEngineInstance(spUnit);
            return engine.invokeProcedure(opContext.getSession(), procedure, values);
        }
        catch (Exception e) {
            LdapOtherException lne = new LdapOtherException(e.getMessage());
            lne.initCause((Throwable)e);
            throw lne;
        }
    }
}

