/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.AvlTreeCursor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractTupleCursor;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTupleAvlCursor<K, V>
extends AbstractTupleCursor<K, V> {
    private final AvlTreeCursor<V> wrapped;
    private final K key;
    private Tuple<K, V> returnedTuple = new Tuple();
    private boolean valueAvailable;

    public KeyTupleAvlCursor(AvlTree<V> avlTree, K key) {
        this.key = key;
        this.wrapped = new AvlTreeCursor<V>(avlTree);
    }

    private void clearValue() {
        this.returnedTuple.setKey(this.key);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err((String)I18n.ERR_446, (Object[])new Object[0]));
    }

    public void afterKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err((String)I18n.ERR_446, (Object[])new Object[0]));
    }

    public void beforeValue(K key, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException(I18n.err((String)I18n.ERR_446, (Object[])new Object[0]));
        }
        this.wrapped.before(value);
        this.clearValue();
    }

    public void afterValue(K key, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException(I18n.err((String)I18n.ERR_446, (Object[])new Object[0]));
        }
        this.wrapped.after(value);
        this.clearValue();
    }

    public void before(Tuple<K, V> element) throws Exception {
        this.checkNotClosed("before()");
        this.wrapped.before(element.getValue());
        this.clearValue();
    }

    public void after(Tuple<K, V> element) throws Exception {
        this.checkNotClosed("after()");
        this.wrapped.after(element.getValue());
        this.clearValue();
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
        this.clearValue();
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.clearValue();
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.wrapped.previous()) {
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.wrapped.get());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.wrapped.next()) {
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.wrapped.get());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    public Tuple<K, V> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    public boolean isElementReused() {
        return true;
    }
}

