/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryStringSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryStringSyntaxChecker.class);
    private static final long serialVersionUID = 1L;

    public DirectoryStringSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.15");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        for (char c : strValue.toCharArray()) {
            if (c != '\ufffd') continue;
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        LOG.debug("Syntax valid for '{}'", value);
        return true;
    }
}

