/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.components;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageComponentType
implements Comparable<MessageComponentType> {
    public static final MessageComponentType NULL = new MessageComponentType(0, "null");
    public static final MessageComponentType KRB_TKT = new MessageComponentType(1, "ticket");
    public static final MessageComponentType KRB_AUTHENTICATOR = new MessageComponentType(2, "authenticator");
    public static final MessageComponentType KRB_ENC_TKT_PART = new MessageComponentType(3, "encrypted ticket part");
    public static final MessageComponentType KRB_ENC_AS_REP_PART = new MessageComponentType(25, "encrypted initial authentication part");
    public static final MessageComponentType KRB_ENC_TGS_REP_PART = new MessageComponentType(26, "encrypted TGS request part");
    public static final MessageComponentType KRB_ENC_AP_REP_PART = new MessageComponentType(27, "encrypted application request part");
    public static final MessageComponentType KRB_ENC_KRB_PRIV_PART = new MessageComponentType(28, "encrypted application message part");
    public static final MessageComponentType KRB_ENC_KRB_CRED_PART = new MessageComponentType(29, "encrypted credentials forward part");
    private static final MessageComponentType[] values = new MessageComponentType[]{NULL, KRB_TKT, KRB_AUTHENTICATOR, KRB_ENC_TKT_PART, KRB_ENC_AS_REP_PART, KRB_ENC_TGS_REP_PART, KRB_ENC_AP_REP_PART, KRB_ENC_KRB_PRIV_PART, KRB_ENC_KRB_CRED_PART};
    public static final List<MessageComponentType> VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private MessageComponentType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static MessageComponentType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (MessageComponentType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return NULL;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(MessageComponentType that) {
        return this.ordinal - that.ordinal;
    }

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }
}

