/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.MessageException;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.message.internal.InternalMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InternalAbstractMessage
implements InternalMessage {
    static final long serialVersionUID = 7601738291101182094L;
    private final Map<String, Control> controls;
    private final int id;
    private final MessageTypeEnum type;
    private final Map<Object, Object> parameters;

    protected InternalAbstractMessage(int id, MessageTypeEnum type) {
        this.id = id;
        this.type = type;
        this.controls = new HashMap<String, Control>();
        this.parameters = new HashMap<Object, Object>();
    }

    @Override
    public int getMessageId() {
        return this.id;
    }

    @Override
    public Map<String, Control> getControls() {
        return Collections.unmodifiableMap(this.controls);
    }

    @Override
    public boolean hasControl(String oid) {
        return this.controls.containsKey(oid);
    }

    @Override
    public void add(Control control) throws MessageException {
        this.controls.put(control.getOid(), control);
    }

    @Override
    public void remove(Control control) throws MessageException {
        this.controls.remove(control.getOid());
    }

    @Override
    public MessageTypeEnum getType() {
        return this.type;
    }

    @Override
    public Object get(Object key) {
        return this.parameters.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.parameters.put(key, value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof InternalMessage)) {
            return false;
        }
        InternalMessage msg = (InternalMessage)obj;
        if (msg.getMessageId() != this.id) {
            return false;
        }
        if (msg.getType() != this.type) {
            return false;
        }
        Map<String, Control> controls = msg.getControls();
        if (controls.size() != this.controls.size()) {
            return false;
        }
        Iterator<String> list = this.controls.keySet().iterator();
        while (list.hasNext()) {
            if (controls.containsKey(list.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + this.id;
        hash = hash * 17 + (this.type == null ? 0 : this.type.hashCode());
        hash = hash * 17 + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        hash = hash * 17 + (this.controls == null ? 0 : ((Object)this.controls).hashCode());
        return hash;
    }

    @Override
    public void addAll(Control[] controls) throws MessageException {
        for (Control c : controls) {
            this.controls.put(c.getOid(), c);
        }
    }
}

