/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.naming.NamingException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.DefaultServerAttribute;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;

class JavaLdapSupport {
    public static final String JOBJECT_ATTR = "javaObject";
    public static final String JCONTAINER_ATTR = "javaContainer";
    public static final String JSERIALIZEDOBJ_ATTR = "javaSerializedObject";
    public static final String JCLASSNAME_ATTR = "javaClassName";
    public static final String JCLASSNAMES_ATTR = "javaClassNames";
    public static final String JSERIALDATA_ATTR = "javaSerializedData";

    JavaLdapSupport() {
    }

    static Object deserialize(ServerEntry serverEntry) throws NamingException {
        ObjectInputStream in = null;
        String className = null;
        try {
            className = serverEntry.get(JCLASSNAME_ATTR).getString();
        }
        catch (LdapInvalidAttributeValueException liave) {
            NamingException ne = new NamingException(I18n.err((String)I18n.ERR_479, (Object[])new Object[]{className, liave.getLocalizedMessage()}));
            ne.setRootCause(liave);
            throw ne;
        }
        try {
            byte[] data = serverEntry.get(JSERIALDATA_ATTR).getBytes();
            in = new ObjectInputStream(new ByteArrayInputStream(data));
            Object ne = in.readObject();
            return ne;
        }
        catch (Exception e) {
            NamingException ne = new NamingException(I18n.err((String)I18n.ERR_479, (Object[])new Object[]{className, e.getLocalizedMessage()}));
            ne.setRootCause(e);
            throw ne;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new NamingException(I18n.err((String)I18n.ERR_480, (Object[])new Object[0]));
            }
        }
    }

    static byte[] serialize(Object obj) throws LdapException {
        ByteArrayOutputStream bytesOut = null;
        ObjectOutputStream out = null;
        try {
            bytesOut = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bytesOut);
            out.writeObject(obj);
            byte[] byArray = bytesOut.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LdapException ne = new LdapException(I18n.err((String)I18n.ERR_481, (Object[])new Object[]{obj, e.getLocalizedMessage()}));
            throw ne;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new LdapException(I18n.err((String)I18n.ERR_482, (Object[])new Object[0]));
            }
        }
    }

    static void serialize(ServerEntry entry, Object obj, SchemaManager schemaManager) throws LdapException {
        entry.put("objectClass", new String[]{"top", JOBJECT_ATTR, JCONTAINER_ATTR, JSERIALIZEDOBJ_ATTR});
        entry.put(JCLASSNAME_ATTR, new String[]{obj.getClass().getName()});
        entry.put(JSERIALDATA_ATTR, (byte[][])new byte[][]{JavaLdapSupport.serialize(obj)});
        Class<?>[] classes = obj.getClass().getClasses();
        AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(JCLASSNAMES_ATTR);
        DefaultServerAttribute javaClassNames = new DefaultServerAttribute(attributeType, new String[]{JCLASSNAMES_ATTR});
        for (int ii = 0; ii < classes.length; ++ii) {
            javaClassNames.add(new String[]{classes[ii].getName()});
        }
        entry.put(new EntryAttribute[]{javaClassNames});
    }
}

