/**
* OWASP Benchmark Project
*
* This file is part of the Open Web Application Security Project (OWASP)
* Benchmark Project For details, please see
* <a href="https://www.owasp.org/index.php/Benchmark">https://www.owasp.org/index.php/Benchmark</a>.
*
* The OWASP Benchmark is free software: you can redistribute it and/or modify it under the terms
* of the GNU General Public License as published by the Free Software Foundation, version 2.
*
* The OWASP Benchmark is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
* even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details
*
* @author Dave Wichers <a href="https://www.aspectsecurity.com">Aspect Security</a>
* @created 2015
*/

package org.owasp.benchmark.score.parsers;

import org.owasp.benchmark.score.BenchmarkScore;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.File;
import java.io.FileInputStream;

public class CafehunterReader extends Reader {
	
	public TestResults parse( File f ) throws Exception {
		DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		// Prevent XXE
		docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
		DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
		InputSource is = new InputSource( new FileInputStream(f) );
		Document doc = docBuilder.parse(is);
		
		TestResults tr = new TestResults( "CafeHunter" ,false,TestResults.ToolType.SAST);
		
		// If the filename includes an elapsed time in seconds (e.g., TOOLNAME-seconds.xml), set the compute time on the scorecard.
		tr.setTime(f);

		Node root = doc.getDocumentElement();
		String version = getAttributeValue( "version", root );
        tr.setToolVersion( version );
		
		NodeList nl = root.getChildNodes();
		for ( int i = 0; i < nl.getLength(); i++ ) {
			Node n = nl.item( i );
			if ( n.getNodeName().equals( "file")) {
				String file = n.getAttributes().getNamedItem("name").getNodeValue();
				String fileName = new File(file).getName();
				if(!fileName.startsWith(BenchmarkScore.BENCHMARKTESTNAME)) {
					continue;
				}

			    NodeList vs = n.getChildNodes();
			    for ( int j = 0; j < vs.getLength(); j++ ) {
					n = vs.item(j);
			        if ( n.getNodeName().equals( "violation" ) ) {
		                TestCaseResult tcr = parseCafeHunterItem( n, fileName );
		                if ( tcr != null ) {
		                    tr.put( tcr );
		                }
			        }
			    }
			}
		}
		
		return tr;
	}
	
	private TestCaseResult parseCafeHunterItem(Node n, String fileName) {
		NamedNodeMap attrs = n.getAttributes();
        String rule = attrs.getNamedItem( "rule" ).getNodeValue();

		TestCaseResult tcr = new TestCaseResult();
	    String test = fileName.replace(".java", "");
		String testNumber = test.substring( BenchmarkScore.BENCHMARKTESTNAME.length() );
		tcr.setNumber( Integer.parseInt( testNumber ) );
		tcr.setCWE( Integer.valueOf(rule.replace("CWE-", "").replace("TOP25-", "")));

		tcr.setCategory( rule );
		tcr.setEvidence( rule );
		return tcr;
	}
}
