/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.replay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryReplayCache
extends Thread
implements ReplayCache {
    private Map<KerberosPrincipal, List<ReplayCacheEntry>> cache = new HashMap<KerberosPrincipal, List<ReplayCacheEntry>>();
    private static final long DEFAULT_CLOCK_SKEW = 300000L;
    private long clockSkew = 300000L;
    private static long DEFAULT_DELAY = 5000L;
    private long delay;

    public InMemoryReplayCache() {
        this.delay = DEFAULT_DELAY;
        this.start();
    }

    public InMemoryReplayCache(long clockSkew) {
        this.delay = DEFAULT_DELAY;
        this.clockSkew = clockSkew;
        this.start();
    }

    public InMemoryReplayCache(long clockSkew, int delay) {
        this.delay = delay;
        this.clockSkew = clockSkew;
        this.start();
    }

    public InMemoryReplayCache(int delay) {
        this.delay = delay;
        this.clockSkew = 300000L;
    }

    public void setClockSkew(long clockSkew) {
        this.clockSkew = clockSkew;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    public synchronized boolean isReplay(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
        List<ReplayCacheEntry> entries = this.cache.get(clientPrincipal);
        if (entries == null || entries.size() == 0) {
            return false;
        }
        for (ReplayCacheEntry entry : entries) {
            if (!serverPrincipal.equals(entry.serverPrincipal) || !clientTime.equals(entry.clientTime) || clientMicroSeconds != entry.clientMicroSeconds) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void save(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
        List<ReplayCacheEntry> entries = this.cache.get(clientPrincipal);
        if (entries == null) {
            entries = new ArrayList<ReplayCacheEntry>();
        }
        entries.add(new ReplayCacheEntry(serverPrincipal, clientPrincipal, clientTime, clientMicroSeconds));
        this.cache.put(clientPrincipal, entries);
    }

    public Map<KerberosPrincipal, List<ReplayCacheEntry>> getCache() {
        return this.cache;
    }

    private synchronized void cleanCache() {
        Collection<List<ReplayCacheEntry>> entryList = this.cache.values();
        if (entryList == null || entryList.size() == 0) {
            return;
        }
        for (List<ReplayCacheEntry> entries : entryList) {
            ReplayCacheEntry entry;
            if (entries == null || entries.size() == 0) continue;
            Iterator<ReplayCacheEntry> iterator = entries.iterator();
            while (iterator.hasNext() && (entry = iterator.next()).isOutsideClockSkew(this.clockSkew)) {
                iterator.remove();
            }
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(this.delay);
                this.cleanCache();
            }
        }
        catch (InterruptedException ie) {
            return;
        }
    }

    public class ReplayCacheEntry {
        private KerberosPrincipal serverPrincipal;
        private KerberosPrincipal clientPrincipal;
        private KerberosTime clientTime;
        private int clientMicroSeconds;

        public ReplayCacheEntry(KerberosPrincipal serverPrincipal, KerberosPrincipal clientPrincipal, KerberosTime clientTime, int clientMicroSeconds) {
            this.serverPrincipal = serverPrincipal;
            this.clientPrincipal = clientPrincipal;
            this.clientTime = clientTime;
            this.clientMicroSeconds = clientMicroSeconds;
        }

        public boolean equals(ReplayCacheEntry that) {
            return this.serverPrincipal.equals(that.serverPrincipal) && this.clientPrincipal.equals(that.clientPrincipal) && this.clientTime.equals(that.clientTime) && this.clientMicroSeconds == that.clientMicroSeconds;
        }

        public boolean isOutsideClockSkew(long clockSkew) {
            return !this.clientTime.isInClockSkew(clockSkew);
        }
    }
}

