/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.schema.registries.OidRegistry;

public class RefinementLeafEvaluator {
    private final OidRegistry registry;

    public RefinementLeafEvaluator(OidRegistry registry) {
        this.registry = registry;
    }

    public boolean evaluate(SimpleNode node, EntryAttribute objectClasses) throws LdapException {
        if (node == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_295, (Object[])new Object[0]));
        }
        if (!(node instanceof EqualityNode)) {
            throw new LdapException(I18n.err((String)I18n.ERR_301, (Object[])new Object[]{node}));
        }
        if (!node.getAttribute().equalsIgnoreCase("objectClass")) {
            throw new LdapException(I18n.err((String)I18n.ERR_302, (Object[])new Object[]{node.getAttribute()}));
        }
        if (null == objectClasses) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_303, (Object[])new Object[0]));
        }
        if (!objectClasses.instanceOf("objectClass")) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_304, (Object[])new Object[0]));
        }
        String value = node.getValue().getString();
        if (objectClasses.contains(new String[]{value})) {
            return true;
        }
        if (Character.isDigit(value.charAt(0))) {
            for (String objectClass : this.registry.getNameSet(value)) {
                if (!objectClasses.contains(new String[]{objectClass})) continue;
                return true;
            }
        }
        return false;
    }
}

