/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.exception;

import java.util.List;
import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapAliasException;
import org.apache.directory.shared.ldap.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;

public class ExceptionInterceptor
extends BaseInterceptor {
    private PartitionNexus nexus;
    private DirectoryService directoryService;
    private DN subschemSubentryDn;
    private final LRUMap notAliasCache = new LRUMap(100);
    private static final int DEFAULT_CACHE_SIZE = 100;

    public void init(DirectoryService directoryService) throws Exception {
        this.directoryService = directoryService;
        this.nexus = directoryService.getPartitionNexus();
        Value attr = this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        this.subschemSubentryDn = new DN(attr.getString());
        this.subschemSubentryDn.normalize(directoryService.getSchemaManager().getNormalizerMapping());
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws Exception {
        boolean notAnAlias;
        DN name = opContext.getDn();
        if (this.subschemSubentryDn.getNormName().equals(name.getNormName())) {
            throw new LdapEntryAlreadyExistsException(I18n.err((String)I18n.ERR_249, (Object[])new Object[0]));
        }
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), name))) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((String)I18n.ERR_250, (Object[])new Object[]{name.getName()}));
            throw ne;
        }
        DN suffix = this.nexus.getSuffix(new GetSuffixOperationContext(this.directoryService.getAdminSession(), name));
        if (suffix.equals((Object)name)) {
            nextInterceptor.add(opContext);
            return;
        }
        DN parentDn = (DN)name.clone();
        parentDn.remove(name.size() - 1);
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            notAnAlias = this.notAliasCache.containsKey((Object)parentDn.getNormName());
        }
        if (!notAnAlias) {
            ClonedServerEntry attrs;
            try {
                attrs = opContext.lookup(parentDn, ByPassConstants.LOOKUP_BYPASS);
            }
            catch (Exception e) {
                LdapNoSuchObjectException e2 = new LdapNoSuchObjectException(I18n.err((String)I18n.ERR_251, (Object[])new Object[]{parentDn.getName()}));
                throw e2;
            }
            EntryAttribute objectClass = attrs.getOriginalEntry().get("objectClass");
            if (objectClass.contains(new String[]{"alias"})) {
                String msg = I18n.err((String)I18n.ERR_252, (Object[])new Object[]{name.getName()});
                LdapAliasException e = new LdapAliasException(msg);
                throw e;
            }
            LRUMap lRUMap2 = this.notAliasCache;
            synchronized (lRUMap2) {
                this.notAliasCache.put((Object)parentDn.getNormName(), (Object)parentDn);
            }
        }
        nextInterceptor.add(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws Exception {
        DN name = opContext.getDn();
        if (name.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((String)I18n.ERR_253, (Object[])new Object[]{this.subschemSubentryDn}));
        }
        String msg = "Attempt to delete non-existant entry: ";
        this.assertHasEntry(nextInterceptor, (OperationContext)opContext, msg, name);
        boolean hasChildren = false;
        EntryFilteringCursor list = nextInterceptor.list(new ListOperationContext(opContext.getSession(), name));
        if (list.next()) {
            hasChildren = true;
        }
        list.close();
        if (hasChildren) {
            LdapContextNotEmptyException e = new LdapContextNotEmptyException();
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)name.getNormName())) {
                this.notAliasCache.remove((Object)name.getNormName());
            }
        }
        nextInterceptor.delete(opContext);
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        if (opContext.getDn().getNormName().equals(this.subschemSubentryDn.getNormName())) {
            return new BaseEntryFilteringCursor((Cursor)new EmptyCursor(), (SearchingOperationContext)opContext);
        }
        String msg = "Attempt to search under non-existant entry: ";
        this.assertHasEntry(nextInterceptor, (OperationContext)opContext, msg, opContext.getDn());
        return nextInterceptor.list(opContext);
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        if (opContext.getDn().getNormName().equals(this.subschemSubentryDn.getNormName())) {
            return this.nexus.getRootDSE(null);
        }
        String msg = "Attempt to lookup non-existant entry: ";
        this.assertHasEntry(nextInterceptor, (OperationContext)opContext, msg, opContext.getDn());
        return nextInterceptor.lookup(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws Exception {
        String msg = "Attempt to modify non-existant entry: ";
        if (opContext.getDn().getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            nextInterceptor.modify(opContext);
            return;
        }
        this.assertHasEntry(nextInterceptor, (OperationContext)opContext, msg, opContext.getDn());
        ClonedServerEntry entry = opContext.lookup(opContext.getDn(), ByPassConstants.LOOKUP_BYPASS);
        List items = opContext.getModItems();
        for (Modification item : items) {
            EntryAttribute modAttr;
            EntryAttribute entryAttr;
            if (item.getOperation() != ModificationOperation.ADD_ATTRIBUTE || (entryAttr = entry.get((modAttr = item.getAttribute()).getId())) == null) continue;
            for (Value value : modAttr) {
                if (!entryAttr.contains(new Value[]{value})) continue;
                throw new LdapAttributeInUseException(I18n.err((String)I18n.ERR_254, (Object[])new Object[]{value, modAttr.getId()}));
            }
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)opContext.getDn().getNormName())) {
                this.notAliasCache.remove((Object)opContext.getDn().getNormName());
            }
        }
        nextInterceptor.modify(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws Exception {
        DN dn = opContext.getDn();
        if (dn.equals((Object)this.subschemSubentryDn)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((String)I18n.ERR_255, (Object[])new Object[]{this.subschemSubentryDn, this.subschemSubentryDn}));
        }
        if (opContext.getEntry() == null) {
            LdapNoSuchObjectException ldnfe = new LdapNoSuchObjectException(I18n.err((String)I18n.ERR_256, (Object[])new Object[]{dn.getName()}));
            throw ldnfe;
        }
        DN newDn = opContext.getNewDn();
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), newDn))) {
            LdapEntryAlreadyExistsException e = new LdapEntryAlreadyExistsException(I18n.err((String)I18n.ERR_257, (Object[])new Object[]{newDn.getName()}));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)dn.getNormName())) {
                this.notAliasCache.remove((Object)dn.getNormName());
            }
        }
        nextInterceptor.rename(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws Exception {
        DN oriChildName = opContext.getDn();
        DN newParentName = opContext.getParent();
        if (oriChildName.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((String)I18n.ERR_258, (Object[])new Object[]{this.subschemSubentryDn, this.subschemSubentryDn}));
        }
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, (OperationContext)opContext, msg, oriChildName);
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, (OperationContext)opContext, msg, newParentName);
        String rdn = oriChildName.get(oriChildName.size() - 1);
        DN target = (DN)newParentName.clone();
        target.add(rdn);
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), target))) {
            String upRdn = new DN(oriChildName.getName()).get(oriChildName.size() - 1);
            DN upTarget = (DN)newParentName.clone();
            upTarget.add(upRdn);
            LdapEntryAlreadyExistsException e = new LdapEntryAlreadyExistsException(I18n.err((String)I18n.ERR_257, (Object[])new Object[]{upTarget.getName()}));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)oriChildName.getNormName())) {
                this.notAliasCache.remove((Object)oriChildName.getNormName());
            }
        }
        nextInterceptor.move(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws Exception {
        DN oriChildName = opContext.getDn();
        DN parent = opContext.getParent();
        if (oriChildName.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((String)I18n.ERR_258, (Object[])new Object[]{this.subschemSubentryDn, this.subschemSubentryDn}));
        }
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, (OperationContext)opContext, msg, oriChildName);
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, (OperationContext)opContext, msg, parent);
        DN target = (DN)parent.clone();
        target.add(opContext.getNewRdn());
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), target))) {
            DN upTarget = (DN)parent.clone();
            upTarget.add(opContext.getNewRdn());
            LdapEntryAlreadyExistsException e = new LdapEntryAlreadyExistsException(I18n.err((String)I18n.ERR_257, (Object[])new Object[]{upTarget.getName()}));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey((Object)oriChildName.getNormName())) {
                this.notAliasCache.remove((Object)oriChildName.getNormName());
            }
        }
        nextInterceptor.moveAndRename(opContext);
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        DN base = opContext.getDn();
        try {
            EntryFilteringCursor cursor = nextInterceptor.search(opContext);
            if (!(cursor.next() || base.isEmpty() || this.subschemSubentryDn.getNormName().equalsIgnoreCase(base.getNormName()))) {
                this.assertHasEntry(nextInterceptor, (OperationContext)opContext, "Attempt to search under non-existant entry:", base);
            }
            return cursor;
        }
        catch (Exception ne) {
            String msg = I18n.err((String)I18n.ERR_259, (Object[])new Object[0]);
            this.assertHasEntry(nextInterceptor, (OperationContext)opContext, msg, base);
            throw ne;
        }
    }

    private void assertHasEntry(NextInterceptor nextInterceptor, OperationContext opContext, String msg, DN dn) throws Exception {
        if (this.subschemSubentryDn.getNormName().equals(dn.getNormName())) {
            return;
        }
        if (!opContext.hasEntry(dn, ByPassConstants.HAS_ENTRY_BYPASS)) {
            LdapNoSuchObjectException e = msg != null ? new LdapNoSuchObjectException(msg + dn.getName()) : new LdapNoSuchObjectException(dn.getName());
            throw e;
        }
    }
}

