/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import java.util.List;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.request.AbstractRequestDsml;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.search.AndFilter;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.codec.search.NotFilter;
import org.apache.directory.shared.ldap.codec.search.OrFilter;
import org.apache.directory.shared.ldap.codec.search.PresentFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class SearchRequestDsml
extends AbstractRequestDsml {
    public SearchRequestDsml() {
        super((LdapMessageCodec)new SearchRequestCodec());
    }

    public SearchRequestDsml(SearchRequestCodec ldapMessage) {
        super((LdapMessageCodec)ldapMessage);
    }

    public MessageTypeEnum getMessageType() {
        return this.instance.getMessageType();
    }

    public Element toDsml(Element root) {
        int derefAliases;
        SearchScope scope;
        Element element = super.toDsml(root);
        SearchRequestCodec request = (SearchRequestCodec)this.instance;
        if (request.getBaseObject() != null) {
            element.addAttribute("dn", request.getBaseObject().getName());
        }
        if ((scope = request.getScope()) != null) {
            if (scope == SearchScope.OBJECT) {
                element.addAttribute("scope", "baseObject");
            } else if (scope == SearchScope.ONELEVEL) {
                element.addAttribute("scope", "singleLevel");
            } else if (scope == SearchScope.SUBTREE) {
                element.addAttribute("scope", "wholeSubtree");
            }
        }
        if ((derefAliases = request.getDerefAliases()) == 0) {
            element.addAttribute("derefAliases", "neverDerefAliases");
        } else if (derefAliases == 1) {
            element.addAttribute("derefAliases", "derefInSearching");
        } else if (derefAliases == 2) {
            element.addAttribute("derefAliases", "derefFindingBaseObj");
        } else if (derefAliases == 3) {
            element.addAttribute("derefAliases", "derefAlways");
        }
        if (request.getSizeLimit() != 0L) {
            element.addAttribute("sizeLimit", "" + request.getSizeLimit());
        }
        if (request.getTimeLimit() != 0) {
            element.addAttribute("timeLimit", "" + request.getTimeLimit());
        }
        if (request.isTypesOnly()) {
            element.addAttribute("typesOnly", "true");
        }
        Element filterElement = element.addElement("filter");
        this.toDsml(filterElement, request.getFilter());
        List attributes = request.getAttributes();
        if (attributes.size() > 0) {
            Element attributesElement = element.addElement("attributes");
            for (EntryAttribute entryAttribute : attributes) {
                attributesElement.addElement("attribute").addAttribute("name", entryAttribute.getId());
            }
        }
        return element;
    }

    private void toDsml(Element element, Filter filter) {
        if (filter instanceof AndFilter) {
            Element newElement = element.addElement("and");
            List filterList = ((AndFilter)filter).getAndFilter();
            for (int i = 0; i < filterList.size(); ++i) {
                this.toDsml(newElement, (Filter)filterList.get(i));
            }
        } else if (filter instanceof OrFilter) {
            Element newElement = element.addElement("or");
            List filterList = ((OrFilter)filter).getOrFilter();
            for (int i = 0; i < filterList.size(); ++i) {
                this.toDsml(newElement, (Filter)filterList.get(i));
            }
        } else if (filter instanceof NotFilter) {
            Element newElement = element.addElement("not");
            this.toDsml(newElement, ((NotFilter)filter).getNotFilter());
        } else if (filter instanceof SubstringFilter) {
            Element newElement = element.addElement("substrings");
            SubstringFilter substringFilter = (SubstringFilter)filter;
            newElement.addAttribute("name", substringFilter.getType());
            String initial = substringFilter.getInitialSubstrings();
            if (initial != null && !"".equals(initial)) {
                newElement.addElement("initial").setText(initial);
            }
            List anyList = substringFilter.getAnySubstrings();
            for (int i = 0; i < anyList.size(); ++i) {
                newElement.addElement("any").setText((String)anyList.get(i));
            }
            String finalString = substringFilter.getFinalSubstrings();
            if (finalString != null && !"".equals(finalString)) {
                newElement.addElement("final").setText(finalString);
            }
        } else if (filter instanceof AttributeValueAssertionFilter) {
            AttributeValueAssertionFilter avaFilter = (AttributeValueAssertionFilter)filter;
            Element newElement = null;
            int filterType = avaFilter.getFilterType();
            if (filterType == 3) {
                newElement = element.addElement("approxMatch");
            } else if (filterType == 0) {
                newElement = element.addElement("equalityMatch");
            } else if (filterType == 1) {
                newElement = element.addElement("greaterOrEqual");
            } else if (filterType == 2) {
                newElement = element.addElement("lessOrEqual");
            }
            AttributeValueAssertion assertion = avaFilter.getAssertion();
            if (assertion != null) {
                newElement.addAttribute("name", assertion.getAttributeDesc());
                Value value = assertion.getAssertionValue();
                if (value != null) {
                    if (ParserUtils.needsBase64Encoding(value)) {
                        Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                        Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                        element.getDocument().getRootElement().add(xsdNamespace);
                        element.getDocument().getRootElement().add(xsiNamespace);
                        Element valueElement = newElement.addElement("value").addText(ParserUtils.base64Encode(value));
                        valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                    } else {
                        newElement.addElement("value").setText((String)value);
                    }
                }
            }
        } else if (filter instanceof PresentFilter) {
            Element newElement = element.addElement("present");
            newElement.addAttribute("name", ((PresentFilter)filter).getAttributeDescription());
        } else if (filter instanceof ExtensibleMatchFilter) {
            String matchingRule;
            Element newElement = element.addElement("extensibleMatch");
            ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)filter;
            Value value = extensibleMatchFilter.getMatchValue();
            if (value != null) {
                if (ParserUtils.needsBase64Encoding(value)) {
                    Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                    Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                    element.getDocument().getRootElement().add(xsdNamespace);
                    element.getDocument().getRootElement().add(xsiNamespace);
                    Element valueElement = newElement.addElement("value").addText(ParserUtils.base64Encode(value));
                    valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                } else {
                    newElement.addElement("value").setText((String)value);
                }
            }
            if (extensibleMatchFilter.isDnAttributes()) {
                newElement.addAttribute("dnAttributes", "true");
            }
            if ((matchingRule = extensibleMatchFilter.getMatchingRule()) != null && "".equals(matchingRule)) {
                newElement.addAttribute("matchingRule", matchingRule);
            }
        }
    }
}

