/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClonedServerEntry
implements ServerEntry {
    private final ServerEntry originalEntry;
    private final ServerEntry clonedEntry;

    public ClonedServerEntry(ServerEntry originalEntry) {
        this.originalEntry = (ServerEntry)originalEntry.clone();
        this.clonedEntry = (ServerEntry)originalEntry.clone();
    }

    public ServerEntry getOriginalEntry() {
        return this.originalEntry;
    }

    public Entry getClonedEntry() {
        return this.clonedEntry;
    }

    public void add(AttributeType attributeType, byte[] ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public void add(AttributeType attributeType, String ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public void add(AttributeType attributeType, Value<?> ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public void add(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public void add(String upId, AttributeType attributeType, String ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public void add(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        this.clonedEntry.add(attributeType, values);
    }

    public boolean contains(AttributeType attributeType, byte[] ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    public boolean contains(AttributeType attributeType, String ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    public boolean contains(AttributeType attributeType, Value<?> ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    public boolean containsAttribute(AttributeType attributeType) {
        return this.clonedEntry.containsAttribute(attributeType);
    }

    public EntryAttribute get(AttributeType attributeType) {
        return this.clonedEntry.get(attributeType);
    }

    public Set<AttributeType> getAttributeTypes() {
        return this.clonedEntry.getAttributeTypes();
    }

    public boolean hasObjectClass(EntryAttribute objectClass) {
        return this.clonedEntry.hasObjectClass(objectClass);
    }

    public boolean isValid() {
        return this.clonedEntry.isValid();
    }

    public boolean isValid(String objectClass) {
        return this.clonedEntry.isValid(objectClass);
    }

    public boolean isValid(EntryAttribute objectClass) {
        return this.clonedEntry.isValid(objectClass);
    }

    public EntryAttribute put(AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    public EntryAttribute put(AttributeType attributeType, String ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    public EntryAttribute put(AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    public EntryAttribute put(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.clonedEntry.put(attributeType, values);
    }

    public EntryAttribute put(String upId, AttributeType attributeType, String ... values) throws LdapException {
        return this.clonedEntry.put(upId, attributeType, values);
    }

    public EntryAttribute put(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.clonedEntry.put(upId, attributeType, values);
    }

    public boolean remove(AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.clonedEntry.remove(attributeType, values);
    }

    public boolean remove(AttributeType attributeType, String ... values) throws LdapException {
        return this.clonedEntry.remove(attributeType, values);
    }

    public boolean remove(AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.clonedEntry.remove(attributeType, values);
    }

    public List<EntryAttribute> remove(EntryAttribute ... attributes) throws LdapException {
        return this.clonedEntry.remove(attributes);
    }

    public List<EntryAttribute> removeAttributes(AttributeType ... attributes) {
        return this.clonedEntry.removeAttributes(attributes);
    }

    public List<EntryAttribute> set(AttributeType ... attributeTypes) {
        return this.clonedEntry.set(attributeTypes);
    }

    public void add(EntryAttribute ... attributes) throws LdapException {
        this.clonedEntry.add(attributes);
    }

    public void add(String upId, String ... values) throws LdapException {
        this.clonedEntry.add(upId, values);
    }

    public void add(String upId, byte[] ... values) throws LdapException {
        this.clonedEntry.add(upId, values);
    }

    public void add(String upId, Value<?> ... values) throws LdapException {
        this.clonedEntry.add(upId, values);
    }

    public void clear() {
        this.clonedEntry.clear();
    }

    public boolean contains(EntryAttribute ... attributes) throws LdapException {
        return this.clonedEntry.contains(attributes);
    }

    public boolean contains(String upId, byte[] ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    public boolean contains(String upId, String ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    public boolean contains(String upId, Value<?> ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    public boolean containsAttribute(String ... attributes) {
        return this.clonedEntry.containsAttribute(attributes);
    }

    public EntryAttribute get(String alias) {
        return this.clonedEntry.get(alias);
    }

    public DN getDn() {
        return this.clonedEntry.getDn();
    }

    public boolean hasObjectClass(String objectClass) {
        return this.clonedEntry.hasObjectClass(objectClass);
    }

    public Iterator<EntryAttribute> iterator() {
        return this.clonedEntry.iterator();
    }

    public List<EntryAttribute> put(EntryAttribute ... attributes) throws LdapException {
        return this.clonedEntry.put(attributes);
    }

    public EntryAttribute put(String upId, byte[] ... values) {
        return this.clonedEntry.put(upId, values);
    }

    public EntryAttribute put(String upId, String ... values) {
        return this.clonedEntry.put(upId, values);
    }

    public EntryAttribute put(String upId, Value<?> ... values) {
        return this.clonedEntry.put(upId, values);
    }

    public boolean remove(String upId, byte[] ... values) throws LdapException {
        return this.clonedEntry.remove(upId, values);
    }

    public boolean remove(String upId, String ... values) throws LdapException {
        return this.clonedEntry.remove(upId, values);
    }

    public boolean remove(String upId, Value<?> ... values) throws LdapException {
        return this.clonedEntry.remove(upId, values);
    }

    public List<EntryAttribute> removeAttributes(String ... attributes) {
        return this.clonedEntry.removeAttributes(attributes);
    }

    public List<EntryAttribute> set(String ... upIds) {
        return this.clonedEntry.set(upIds);
    }

    public void setDn(DN dn) {
        this.clonedEntry.setDn(dn);
    }

    public int size() {
        return this.clonedEntry.size();
    }

    public Entry toClientEntry() throws LdapException {
        DefaultClientEntry clientEntry = new DefaultClientEntry(this.clonedEntry.getDn());
        Iterator<EntryAttribute> i$ = this.iterator();
        while (i$.hasNext()) {
            EntryAttribute clonedEntry = i$.next();
            EntryAttribute clientAttribute = clonedEntry.toClientAttribute();
            clientEntry.add(new EntryAttribute[]{clientAttribute});
        }
        return clientEntry;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException(I18n.err((String)I18n.ERR_455, (Object[])new Object[0]));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException(I18n.err((String)I18n.ERR_456, (Object[])new Object[0]));
    }

    public ServerEntry clone() {
        return (ServerEntry)this.clonedEntry.clone();
    }

    public boolean equals(Object obj) {
        Entry other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClonedServerEntry) {
            other = ((ClonedServerEntry)obj).getClonedEntry();
        } else if (obj instanceof ServerEntry) {
            other = (ServerEntry)obj;
        } else {
            return false;
        }
        return this.clonedEntry.equals(other);
    }

    public String toString() {
        return this.clonedEntry.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EmptyEntry
    implements ServerEntry {
        DN dn;

        EmptyEntry(DN dn) {
            this.dn = dn;
        }

        public void add(AttributeType attributeType, byte[] ... values) throws LdapException {
        }

        public void add(AttributeType attributeType, String ... values) throws LdapException {
        }

        public void add(AttributeType attributeType, Value<?> ... values) throws LdapException {
        }

        public void add(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        }

        public void add(String upId, AttributeType attributeType, String ... values) throws LdapException {
        }

        public void add(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        }

        public boolean contains(AttributeType attributeType, byte[] ... values) {
            return false;
        }

        public boolean contains(AttributeType attributeType, String ... values) {
            return false;
        }

        public boolean contains(AttributeType attributeType, Value<?> ... values) {
            return false;
        }

        public boolean containsAttribute(AttributeType attributeType) {
            return false;
        }

        public EntryAttribute get(AttributeType attributeType) {
            return null;
        }

        public Set<AttributeType> getAttributeTypes() {
            return null;
        }

        public boolean hasObjectClass(EntryAttribute objectClass) {
            return false;
        }

        public boolean isValid() {
            return false;
        }

        public boolean isValid(String objectClass) {
            return false;
        }

        public boolean isValid(EntryAttribute objectClass) {
            return false;
        }

        public EntryAttribute put(AttributeType attributeType, byte[] ... values) throws LdapException {
            return null;
        }

        public EntryAttribute put(AttributeType attributeType, String ... values) throws LdapException {
            return null;
        }

        public EntryAttribute put(AttributeType attributeType, Value<?> ... values) throws LdapException {
            return null;
        }

        public EntryAttribute put(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
            return null;
        }

        public EntryAttribute put(String upId, AttributeType attributeType, String ... values) throws LdapException {
            return null;
        }

        public EntryAttribute put(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
            return null;
        }

        public boolean remove(AttributeType attributeType, byte[] ... values) throws LdapException {
            return false;
        }

        public boolean remove(AttributeType attributeType, String ... values) throws LdapException {
            return false;
        }

        public boolean remove(AttributeType attributeType, Value<?> ... values) throws LdapException {
            return false;
        }

        public List<EntryAttribute> remove(EntryAttribute ... attributes) throws LdapException {
            return Collections.emptyList();
        }

        public List<EntryAttribute> removeAttributes(AttributeType ... attributes) {
            return Collections.emptyList();
        }

        public List<EntryAttribute> set(AttributeType ... attributeTypes) {
            return Collections.emptyList();
        }

        public void add(EntryAttribute ... attributes) throws LdapException {
        }

        public void add(String upId, String ... values) throws LdapException {
        }

        public void add(String upId, byte[] ... values) throws LdapException {
        }

        public void add(String upId, Value<?> ... values) throws LdapException {
        }

        public void clear() {
        }

        public boolean contains(EntryAttribute ... attributes) throws LdapException {
            return false;
        }

        public boolean contains(String upId, byte[] ... values) {
            return false;
        }

        public boolean contains(String upId, String ... values) {
            return false;
        }

        public boolean contains(String upId, Value<?> ... values) {
            return false;
        }

        public boolean containsAttribute(String ... attributes) {
            return false;
        }

        public EntryAttribute get(String alias) {
            return null;
        }

        public DN getDn() {
            return null;
        }

        public boolean hasObjectClass(String objectClass) {
            return false;
        }

        public Iterator<EntryAttribute> iterator() {
            return Collections.EMPTY_LIST.iterator();
        }

        public List<EntryAttribute> put(EntryAttribute ... attributes) throws LdapException {
            return Collections.emptyList();
        }

        public EntryAttribute put(String upId, byte[] ... values) {
            return null;
        }

        public EntryAttribute put(String upId, String ... values) {
            return null;
        }

        public EntryAttribute put(String upId, Value<?> ... values) {
            return null;
        }

        public boolean remove(String upId, byte[] ... values) throws LdapException {
            return false;
        }

        public boolean remove(String upId, String ... values) throws LdapException {
            return false;
        }

        public boolean remove(String upId, Value<?> ... values) throws LdapException {
            return false;
        }

        public List<EntryAttribute> removeAttributes(String ... attributes) {
            return Collections.emptyList();
        }

        public List<EntryAttribute> set(String ... upIds) {
            return Collections.emptyList();
        }

        public void setDn(DN dn) {
            this.dn = dn;
        }

        public int size() {
            return 0;
        }

        public ServerEntry clone() {
            return new EmptyEntry(this.dn);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public Entry toClientEntry() throws LdapException {
            DefaultClientEntry clientEntry = new DefaultClientEntry(this.dn);
            Iterator<EntryAttribute> i$ = this.iterator();
            while (i$.hasNext()) {
                EntryAttribute serverAttribute = i$.next();
                EntryAttribute clientAttribute = serverAttribute.toClientAttribute();
                clientEntry.add(new EntryAttribute[]{clientAttribute});
            }
            return clientEntry;
        }
    }
}

