/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.cramMD5;

import java.util.HashSet;
import javax.security.sasl.AuthorizeCallback;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractSaslCallbackHandler;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.internal.InternalBindRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CramMd5CallbackHandler
extends AbstractSaslCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CramMd5CallbackHandler.class);
    private String bindDn;

    public CramMd5CallbackHandler(LdapSession ldapSession, CoreSession adminSession, InternalBindRequest bindRequest) {
        super(adminSession.getDirectoryService(), bindRequest);
        this.ldapSession = ldapSession;
        this.adminSession = adminSession;
    }

    protected EntryAttribute lookupPassword(String username, String realm) {
        try {
            ExprNode filter = FilterParser.parse((String)("(uid=" + username + ")"));
            HashSet<AttributeTypeOptions> returningAttributes = new HashSet<AttributeTypeOptions>();
            AttributeType passwordAT = this.adminSession.getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry("userPassword");
            returningAttributes.add(new AttributeTypeOptions(passwordAT));
            this.bindDn = (String)this.ldapSession.getSaslProperty("userBaseDn");
            DN baseDn = new DN(this.bindDn);
            EntryFilteringCursor cursor = this.adminSession.search(baseDn, SearchScope.SUBTREE, filter, AliasDerefMode.DEREF_ALWAYS, returningAttributes);
            cursor.beforeFirst();
            ClonedServerEntry entry = null;
            while (cursor.next()) {
                entry = (ClonedServerEntry)cursor.get();
                LdapPrincipal ldapPrincipal = new LdapPrincipal(entry.getDn(), AuthenticationLevel.STRONG, entry.get("userPassword").getBytes());
                this.ldapSession.putSaslProperty("saslAuthentUser", ldapPrincipal);
            }
            return entry.get(passwordAT);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void authorize(AuthorizeCallback authorizeCB) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converted username " + this.getUsername() + " to DN " + this.bindDn);
        }
        this.ldapSession.putSaslProperty("java.naming.security.principal", this.bindDn);
        authorizeCB.setAuthorizedID(this.bindDn);
        authorizeCB.setAuthorized(true);
    }
}

