/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.extended;

import java.nio.ByteBuffer;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.codec.extended.operations.storedProcedure.StoredProcedure;
import org.apache.directory.shared.ldap.codec.extended.operations.storedProcedure.StoredProcedureContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.storedProcedure.StoredProcedureDecoder;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.extended.StoredProcedureResponse;
import org.apache.directory.shared.ldap.message.internal.InternalResultResponse;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureRequest
extends ExtendedRequestImpl {
    private static final Logger log = LoggerFactory.getLogger(StoredProcedureRequest.class);
    private static final long serialVersionUID = -4682291068700593492L;
    public static final String EXTENSION_OID = "1.3.6.1.4.1.18060.0.1.6";
    private StoredProcedure procedure;

    public StoredProcedureRequest(int messageId) {
        super(messageId);
        this.setOid(EXTENSION_OID);
        this.procedure = new StoredProcedure();
    }

    public StoredProcedureRequest(int messageId, String procedure, String language) {
        super(messageId);
        this.setOid(EXTENSION_OID);
        this.procedure = new StoredProcedure();
        this.setLanguage(language);
        this.setProcedure(procedure);
    }

    private void encodePayload() throws EncoderException {
        this.payload = this.procedure.encode().array();
    }

    @Override
    public void setPayload(byte[] payload) {
        StoredProcedureDecoder decoder = new StoredProcedureDecoder();
        StoredProcedureContainer container = new StoredProcedureContainer();
        try {
            decoder.decode(ByteBuffer.wrap(payload), (IAsn1Container)container);
            this.procedure = container.getStoredProcedure();
        }
        catch (Exception e) {
            log.error(I18n.err((String)"ERR_04165", (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        StoredProcedureResponse resp = (StoredProcedureResponse)this.getResultResponse();
        resp.setResponse(berValue);
        resp.setOid(id);
        return resp;
    }

    @Override
    public byte[] getEncodedValue() {
        return this.getPayload();
    }

    @Override
    public byte[] getPayload() {
        if (this.payload == null) {
            try {
                this.encodePayload();
            }
            catch (EncoderException e) {
                log.error(I18n.err((String)"ERR_04174", (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.payload;
    }

    @Override
    public InternalResultResponse getResultResponse() {
        if (this.response == null) {
            StoredProcedureResponse spr = new StoredProcedureResponse(this.getMessageId());
            spr.setOid(EXTENSION_OID);
            this.response = spr;
        }
        return this.response;
    }

    public String getLanguage() {
        return this.procedure.getLanguage();
    }

    public void setLanguage(String language) {
        this.procedure.setLanguage(language);
    }

    public void setProcedure(String procedure) {
        this.procedure.setProcedure(StringTools.getBytesUtf8(procedure));
    }

    public String getProcedureSpecification() {
        return StringTools.utf8ToString(this.procedure.getProcedure());
    }

    public int size() {
        return this.procedure.getParameters().size();
    }

    public Object getParameterType(int index) {
        if (!this.procedure.getLanguage().equals("java")) {
            return this.procedure.getParameters().get(index).getType();
        }
        return this.getJavaParameterType(index);
    }

    public Class<?> getJavaParameterType(int index) {
        throw new NotImplementedException(I18n.err((String)"ERR_04175", (Object[])new Object[0]));
    }

    public Object getParameterValue(int index) {
        if (!this.procedure.getLanguage().equals("java")) {
            return this.procedure.getParameters().get(index).getValue();
        }
        return this.getJavaParameterValue(index);
    }

    public Object getJavaParameterValue(int index) {
        throw new NotImplementedException(I18n.err((String)"ERR_04176", (Object[])new Object[0]));
    }

    public void addParameter(Object type, Object value) {
        StoredProcedure.StoredProcedureParameter parameter = new StoredProcedure.StoredProcedureParameter();
        parameter.setType((byte[])type);
        parameter.setValue((byte[])value);
        this.procedure.addParameter(parameter);
    }
}

