/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checksum
extends AbstractAsn1Object {
    private static final Logger log = LoggerFactory.getLogger(Checksum.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private ChecksumType cksumtype;
    private byte[] checksum;
    private transient int checksumTypeLength;
    private transient int checksumBytesLength;
    private transient int checksumLength;

    public Checksum() {
    }

    public Checksum(ChecksumType cksumtype, byte[] checksum) {
        this.cksumtype = cksumtype;
        this.checksum = checksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Checksum)) {
            return false;
        }
        Checksum that = (Checksum)((Object)o);
        return this.cksumtype == that.cksumtype && Arrays.equals(this.checksum, that.checksum);
    }

    public byte[] getChecksumValue() {
        return this.checksum;
    }

    public void setChecksumValue(byte[] checksum) {
        this.checksum = checksum;
    }

    public ChecksumType getChecksumType() {
        return this.cksumtype;
    }

    public void setChecksumType(ChecksumType cksumType) {
        this.cksumtype = cksumType;
    }

    public int computeLength() {
        this.checksumTypeLength = 2 + Value.getNbBytes((int)this.cksumtype.getOrdinal());
        this.checksumLength = 1 + TLV.getNbBytes((int)this.checksumTypeLength) + this.checksumTypeLength;
        this.checksumBytesLength = this.checksum == null ? 2 : 1 + TLV.getNbBytes((int)this.checksum.length) + this.checksum.length;
        this.checksumLength += 1 + TLV.getNbBytes((int)this.checksumBytesLength) + this.checksumBytesLength;
        int checksumSeqLength = 1 + Value.getNbBytes((int)this.checksumLength) + this.checksumLength;
        return checksumSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((String)I18n.ERR_148, (Object[])new Object[0]));
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.checksumLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.checksumTypeLength));
            Value.encode((ByteBuffer)buffer, (int)this.cksumtype.getOrdinal());
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.checksumBytesLength));
            Value.encode((ByteBuffer)buffer, (byte[])this.checksum);
        }
        catch (BufferOverflowException boe) {
            log.error(I18n.err((String)I18n.ERR_140, (Object[])new Object[]{1 + TLV.getNbBytes((int)this.checksumLength) + this.checksumLength, buffer.capacity()}));
            throw new EncoderException(I18n.err((String)I18n.ERR_138, (Object[])new Object[0]));
        }
        if (IS_DEBUG) {
            log.debug("Checksum encoding : {}", (Object)StringTools.dumpBytes((byte[])buffer.array()));
            log.debug("Checksum initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("Checksum : {\n");
        sb.append(tabs).append("    cksumtype: ").append(this.cksumtype).append('\n');
        if (this.checksum != null) {
            sb.append(tabs + "    checksum:").append(StringTools.dumpBytes((byte[])this.checksum)).append('\n');
        }
        sb.append(tabs + "}\n");
        return sb.toString();
    }
}

