/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.messages.value.PaData;
import org.apache.directory.server.kerberos.shared.messages.value.types.PaDataType;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class PreAuthenticationDataDecoder {
    public PaData decode(byte[] encodedPreAuthData) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedPreAuthData);
        DERSequence sequence = (DERSequence)ais.readObject();
        return PreAuthenticationDataDecoder.decode(sequence);
    }

    protected static PaData[] decodeSequence(DERSequence sequence) {
        PaData[] paDataSequence = new PaData[sequence.size()];
        int ii = 0;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            PaData paData;
            DERSequence object = (DERSequence)e.nextElement();
            paDataSequence[ii] = paData = PreAuthenticationDataDecoder.decode(object);
            ++ii;
        }
        return paDataSequence;
    }

    protected static PaData decode(DERSequence sequence) {
        PaData paData = new PaData();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 1: {
                    DERInteger padataType = (DERInteger)derObject;
                    PaDataType type = PaDataType.getTypeByOrdinal(padataType.intValue());
                    paData.setPaDataType(type);
                    break;
                }
                case 2: {
                    DEROctetString padataValue = (DEROctetString)derObject;
                    paData.setPaDataValue(padataValue.getOctets());
                }
            }
        }
        return paData;
    }
}

