/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueMemberNormalizer
extends Normalizer {
    private static final long serialVersionUID = 1L;
    private SchemaManager schemaManager;

    public UniqueMemberNormalizer() {
        super("2.5.13.23");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        String nameAndUid = value.getString();
        if (nameAndUid.length() == 0) {
            return null;
        }
        int sharpPos = nameAndUid.lastIndexOf(35);
        if (sharpPos != -1) {
            if (nameAndUid.indexOf(35) != sharpPos) {
                return null;
            }
            String uid = nameAndUid.substring(sharpPos + 1);
            if (sharpPos > 0) {
                DN dn = new DN(nameAndUid.substring(0, sharpPos));
                dn.normalize(this.schemaManager.getNormalizerMapping());
                return new StringValue(dn.getNormName() + '#' + uid);
            }
            throw new IllegalStateException(I18n.err((String)"ERR_04226", (Object[])new Object[]{value.getClass()}));
        }
        return new StringValue(new DN(nameAndUid).getNormName());
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (StringTools.isEmpty(value)) {
            return null;
        }
        int sharpPos = value.lastIndexOf(35);
        if (sharpPos != -1) {
            if (value.indexOf(35) != sharpPos) {
                return null;
            }
            String uid = value.substring(sharpPos + 1);
            if (sharpPos > 0) {
                DN dn = new DN(value.substring(0, sharpPos));
                dn.normalize(this.schemaManager.getNormalizerMapping());
                return dn.getNormName() + '#' + uid;
            }
            throw new IllegalStateException(I18n.err((String)"ERR_04226", (Object[])new Object[]{value.getClass()}));
        }
        return new DN(value).normalize(this.schemaManager.getNormalizerMapping()).getNormName();
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

