/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStringNormalizer
extends Normalizer {
    private static final long serialVersionUID = 1L;
    private static final DefaultStringNormalizer NORMALIZER = new DefaultStringNormalizer();

    protected DefaultStringNormalizer() {
        super("2.5.13.2");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        String str = value.getString();
        if (StringTools.isEmpty(str)) {
            return new StringValue(str);
        }
        return new StringValue(str);
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (StringTools.isEmpty(value)) {
            return value;
        }
        return value;
    }

    public static String normalizeString(String string) throws LdapException {
        return NORMALIZER.normalize(string);
    }
}

